/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.domain.im.common.EntityLink;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.ProductReminderRelationshipEditor;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;

public class ProductReminderRelationshipEditorTestCase
extends AbstractAppTest {
    @Test
    public void testDefaultFromReminderType() {
        Entity type1 = this.createReminderType(2, DateUnits.YEARS, false);
        Entity type2 = this.createReminderType(4, DateUnits.MONTHS, true);
        EntityLink rel = (EntityLink)this.create("entityLink.productReminder", EntityLink.class);
        ProductReminderRelationshipEditor editor = new ProductReminderRelationshipEditor(rel, null, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        this.checkValues(rel, 1, DateUnits.YEARS, false);
        editor.getProperty("target").setValue((Object)type1.getObjectReference());
        this.checkValues(rel, 2, DateUnits.YEARS, false);
        editor.getProperty("target").setValue((Object)type2.getObjectReference());
        this.checkValues(rel, 4, DateUnits.MONTHS, true);
        editor.getProperty("target").setValue(null);
        this.checkValues(rel, 4, DateUnits.MONTHS, true);
    }

    @Test
    public void testFactory() {
        EntityLink rel = (EntityLink)this.create("entityLink.productReminder", EntityLink.class);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        IMObjectEditor editor = context.getEditorFactory().create((IMObject)rel, (LayoutContext)context);
        Assert.assertTrue((boolean)(editor instanceof ProductReminderRelationshipEditor));
    }

    private void checkValues(EntityLink rel, int period, DateUnits periodUom, boolean interactive) {
        IMObjectBean bean = this.getBean((IMObject)rel);
        Assert.assertEquals((long)period, (long)bean.getInt("period"));
        Assert.assertEquals((Object)periodUom.toString(), (Object)bean.getString("periodUom"));
        Assert.assertEquals((Object)interactive, (Object)bean.getBoolean("interactive"));
    }

    private Entity createReminderType(int interval, DateUnits units, boolean interactive) {
        Entity result = (Entity)this.create("entity.reminderType", Entity.class);
        IMObjectBean bean = this.getBean((IMObject)result);
        bean.setValue("name", (Object)("ZReminderType-" + System.currentTimeMillis()));
        bean.setValue("defaultInterval", (Object)interval);
        bean.setValue("defaultUnits", (Object)units.toString());
        bean.setValue("interactive", (Object)interactive);
        this.save((IMObject)result);
        return result;
    }
}

