/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.reminder;

import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.edit.reminder.ReminderEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.beans.factory.annotation.Autowired;

public class ReminderEditorTestCase
extends AbstractAppTest {
    @Autowired
    private ReminderRules rules;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestReminderFactory reminderFactory;
    private Party patient;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.patient = this.patientFactory.createPatient();
    }

    @Test
    public void testDates() {
        Date today = DateRules.getToday();
        Entity reminderType = (Entity)this.reminderFactory.newReminderType().defaultInterval(1, DateUnits.YEARS).newCount().count(0).interval(-2, DateUnits.WEEKS).add().newCount().count(1).interval(-1, DateUnits.WEEKS).add().build();
        Act reminder = (Act)this.create("act.patientReminder", Act.class);
        ReminderEditor editor1 = this.createEditor(reminder, null);
        Assert.assertNull((Object)editor1.getStartTime());
        Assert.assertNull((Object)editor1.getEndTime());
        editor1.setEndTime(new Date());
        Assert.assertNull((Object)editor1.getStartTime());
        editor1.setReminderType(reminderType);
        Date due1 = DateRules.getDate((Date)today, (int)1, (DateUnits)DateUnits.YEARS);
        Date next1 = DateRules.getDate((Date)due1, (int)-2, (DateUnits)DateUnits.WEEKS);
        Assert.assertEquals((Object)due1, (Object)DateRules.getDate((Date)editor1.getEndTime()));
        Assert.assertEquals((Object)next1, (Object)DateRules.getDate((Date)editor1.getStartTime()));
        Date due2 = DateRules.getDate((Date)today, (int)1, (DateUnits)DateUnits.MONTHS);
        editor1.setEndTime(due2);
        Date next2 = DateRules.getDate((Date)due2, (int)-2, (DateUnits)DateUnits.WEEKS);
        Assert.assertEquals((Object)next2, (Object)DateRules.getDate((Date)editor1.getStartTime()));
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        IMObjectBean bean = this.getBean((IMObject)reminder);
        bean.setValue("reminderCount", (Object)1);
        Date due3 = DateRules.getDate((Date)today, (int)2, (DateUnits)DateUnits.MONTHS);
        Date next3 = DateRules.getDate((Date)due3, (int)-1, (DateUnits)DateUnits.WEEKS);
        DefaultLayoutContext layout = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        ReminderEditor editor2 = new ReminderEditor(reminder, null, (LayoutContext)layout);
        editor2.getComponent();
        editor2.setEndTime(due3);
        Assert.assertEquals((Object)next3, (Object)DateRules.getDate((Date)editor2.getStartTime()));
    }

    @Test
    public void testMarkMatchingRemindersCompleted() {
        Entity reminderType = this.reminderFactory.createReminderType();
        Act existing = this.reminderFactory.createReminder(this.patient, reminderType);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)existing.getStatus());
        this.save((IMObject)existing);
        Act reminder = (Act)this.create("act.patientReminder", Act.class);
        ReminderEditor editor = this.createEditor(reminder, reminderType);
        SaveHelper.save((IMObjectEditor)editor);
        existing = (Act)this.get((IMObject)existing);
        Assert.assertEquals((Object)"COMPLETED", (Object)existing.getStatus());
        reminder = (Act)this.get((IMObject)reminder);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)reminder.getStatus());
    }

    @Test
    public void testDisableMarkCompleted() {
        Entity reminderType = this.reminderFactory.createReminderType();
        Act existing = this.reminderFactory.createReminder(this.patient, reminderType);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)existing.getStatus());
        this.save((IMObject)existing);
        Act reminder = (Act)this.create("act.patientReminder", Act.class);
        ReminderEditor editor = this.createEditor(reminder, reminderType);
        editor.setMarkMatchingRemindersCompleted(false);
        SaveHelper.save((IMObjectEditor)editor);
        existing = (Act)this.get((IMObject)existing);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)existing.getStatus());
        reminder = (Act)this.get((IMObject)reminder);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)reminder.getStatus());
    }

    @Test
    public void testCompleteOnSave() {
        Entity reminderType = (Entity)this.reminderFactory.newReminderType().defaultInterval(0, DateUnits.WEEKS).build();
        Act reminder = (Act)this.create("act.patientReminder", Act.class);
        ReminderEditor editor = this.createEditor(reminder, reminderType);
        editor.setEndTime(new Date());
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)editor.getStatus());
        Assert.assertTrue((boolean)this.rules.shouldCancel(reminder, new Date()));
        SaveHelper.save((IMObjectEditor)editor);
        Assert.assertEquals((Object)"COMPLETED", (Object)reminder.getStatus());
    }

    protected ReminderEditor createEditor(Act reminder, Entity reminderType) {
        DefaultLayoutContext layout = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        ReminderEditor editor = new ReminderEditor(reminder, null, (LayoutContext)layout);
        editor.getComponent();
        editor.setPatient(this.patient);
        editor.setReminderType(reminderType);
        return editor;
    }
}

