/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.beans.factory.annotation.Autowired;

public class SaveHelperTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    private List<String> errors;

    @Test
    public void testSaveEditor() {
        IMObject customer = this.customerFactory.newCustomer().lastName(ValueStrategy.value(null)).build(false);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        IMObjectEditor editor = context.getEditorFactory().create(customer, (LayoutContext)context);
        Assert.assertFalse((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertEquals((long)-1L, (long)customer.getId());
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)"Failed to validate Last Name of Customer: Last Name is required", (Object)this.errors.get(0));
        this.errors.clear();
        editor.getProperty("lastName").setValue((Object)"ZFoo");
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertEquals((long)0L, (long)this.errors.size());
        Assert.assertNotEquals((long)customer.getId(), (long)-1L);
        this.remove(customer);
        editor.getProperty("lastName").setValue((Object)"ZFoo2");
        Assert.assertFalse((boolean)SaveHelper.save((IMObjectEditor)editor));
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)"Customer may have been deleted by another user", (Object)this.errors.get(0));
    }

    @Test
    public void testSaveObject() {
        Party customer = TestHelper.createCustomer((boolean)false);
        IMObjectBean bean = this.getBean((IMObject)customer);
        bean.setValue("lastName", null);
        Assert.assertFalse((boolean)SaveHelper.save((IMObject)customer));
        Assert.assertEquals((long)-1L, (long)customer.getId());
        String lastName = bean.getDisplayName("lastName");
        String expected = Messages.format((String)"org.openvpms.component.business.service.archetype.ValidationError", (Object[])new Object[]{bean.getDisplayName(), lastName, "value is required"});
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)expected, (Object)this.errors.get(0));
        bean.setValue("lastName", (Object)"ZFoo");
        this.errors.clear();
        Assert.assertTrue((boolean)SaveHelper.save((IMObject)customer));
        Assert.assertEquals((long)0L, (long)this.errors.size());
        Assert.assertNotEquals((long)customer.getId(), (long)-1L);
        this.remove((IMObject)customer);
        Assert.assertFalse((boolean)SaveHelper.save((IMObject)customer));
        expected = Messages.format((String)"imobject.notfound", (Object[])new Object[]{bean.getDisplayName()});
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)expected, (Object)this.errors.get(0));
    }

    @Override
    public void setUp() {
        super.setUp();
        this.errors = new ArrayList<String>();
        this.initErrorHandler(this.errors);
    }
}

