/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.report.ReportFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.doc.DocumentGenerator;
import org.openvpms.web.component.im.doc.DocumentJobManager;
import org.openvpms.web.component.im.doc.DocumentTestHelper;
import org.openvpms.web.component.im.doc.FileNameFormatter;
import org.openvpms.web.component.im.report.DocumentActReporter;
import org.openvpms.web.component.im.report.DocumentTemplateLocatorFactory;
import org.openvpms.web.component.job.JobManager;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.beans.factory.annotation.Autowired;

public class DocumentGeneratorTestCase
extends AbstractAppTest {
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private PatientRules rules;
    @Autowired
    private ReportFactory reportFactory;
    @Autowired
    private DocumentRules documentRules;
    private TestJobManager jobManager;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.jobManager = new TestJobManager();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.jobManager.destroy();
    }

    @Test
    public void testContextFields() throws Exception {
        Party customer = this.customerFactory.createCustomer("Foo", "Bar");
        Entity template = (Entity)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.customerDocumentForm").document("/customerformtemplate.jrxml")).build();
        DocumentAct act = (DocumentAct)this.create("act.customerDocumentForm", DocumentAct.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("customer", (IMObject)customer);
        bean.setTarget("documentTemplate", (IMObject)template);
        Context context = DocumentTestHelper.createReportContext();
        final AtomicReference ref = new AtomicReference();
        final AtomicReference threadRef = new AtomicReference();
        DocumentGenerator.AbstractListener listener = new DocumentGenerator.AbstractListener(){

            public void generated(Document document) {
                ref.set(document);
                threadRef.set(Thread.currentThread());
            }
        };
        DocumentTemplateLocatorFactory factory = new DocumentTemplateLocatorFactory((ArchetypeService)this.getArchetypeService());
        FileNameFormatter formatter = new FileNameFormatter((ArchetypeService)this.getArchetypeService(), this.getLookupService(), this.rules);
        DocumentGenerator generator = new DocumentGenerator(act, factory, context, new HelpContext("foo", null), formatter, (ArchetypeService)this.getArchetypeService(), this.getLookupService(), this.reportFactory, this.jobManager, this.documentRules, (DocumentGenerator.Listener)listener){

            protected Document generate(DocumentActReporter reporter) {
                return reporter.getDocument("text/csv", false);
            }
        };
        generator.generate();
        this.processJobs(2);
        Document document = (Document)ref.get();
        Assert.assertNotNull((Object)document);
        String result = this.documentFactory.toString(document).trim();
        Assert.assertEquals((Object)"Foo,Bar,Vets R Us,Main Clinic,Main Stock,\"Smith,J\",Fido,Vet Supplies,Acepromazine,Main Deposit,Main Till,Vet,User,Visit,Invoice,Appointment,Task", (Object)result);
        Assert.assertEquals((Object)Thread.currentThread(), threadRef.get());
    }

    @Test
    public void testOutputFormat() {
        this.checkOutputFormat("ODT", ".odt");
        this.checkOutputFormat("PDF", ".pdf");
    }

    private void processJobs(int tasks) {
        for (int i = 0; i < tasks; ++i) {
            try {
                Assert.assertTrue((boolean)this.jobManager.semaphore.tryAcquire(10L, TimeUnit.SECONDS));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.processQueuedTasks();
        }
    }

    private void checkOutputFormat(String outputFormat, String extension) {
        Party customer = this.customerFactory.createCustomer("Foo", "Bar");
        Entity template = (Entity)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.customerDocumentLetter").document("/customerlettertemplate.jrxml")).outputFormat(outputFormat).build();
        DocumentAct act = (DocumentAct)this.create("act.customerDocumentLetter", DocumentAct.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("customer", (IMObject)customer);
        bean.setTarget("documentTemplate", (IMObject)template);
        final AtomicReference ref = new AtomicReference();
        DocumentGenerator.AbstractListener listener = new DocumentGenerator.AbstractListener(){

            public void generated(Document document) {
                ref.set(document);
            }
        };
        FileNameFormatter formatter = new FileNameFormatter((ArchetypeService)this.getArchetypeService(), this.getLookupService(), this.rules);
        DocumentTemplateLocatorFactory factory = new DocumentTemplateLocatorFactory((ArchetypeService)this.getArchetypeService());
        DocumentGenerator generator = new DocumentGenerator(act, factory, (Context)new LocalContext(), new HelpContext("foo", null), formatter, (ArchetypeService)this.getArchetypeService(), this.getLookupService(), this.reportFactory, (DocumentJobManager)this.jobManager, this.documentRules, (DocumentGenerator.Listener)listener);
        generator.generate();
        this.processQueuedTasks(10, () -> ref.get() != null);
        Document document = (Document)ref.get();
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)(template.getName() + extension), (Object)document.getName());
    }

    private static class TestJobManager
    extends DocumentJobManager {
        private final Semaphore semaphore = new Semaphore(0);

        private TestJobManager() {
        }

        protected void queueListener(JobManager.State state, Runnable listener) {
            super.queueListener(state, listener);
            this.semaphore.release();
        }
    }
}

