/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.delete;

import org.junit.Assert;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.delete.AbstractIMObjectDeleterTest;
import org.openvpms.web.component.im.delete.ConfirmingDeleter;
import org.openvpms.web.component.im.delete.IMObjectDeleter;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandlerFactory;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.test.EchoTestHelper;

public class ConfirmingDeleterTestCase
extends AbstractIMObjectDeleterTest {
    @Override
    protected IMObjectDeleter<IMObject> createDeleter(IMObjectDeletionHandlerFactory factory) {
        return new ConfirmingDeleter(factory, (ArchetypeService)this.getArchetypeService());
    }

    @Override
    protected void checkDeletionConfirmation(IMObject object) {
        ConfirmationDialog dialog = EchoTestHelper.findWindowPane(ConfirmationDialog.class);
        Assert.assertNotNull((Object)dialog);
        String title = "Delete " + this.getDisplayName(object) + "?";
        String message = "Delete " + object.getName() + "? This operation cannot be undone.";
        Assert.assertEquals((Object)title, (Object)dialog.getTitle());
        Assert.assertEquals((Object)message, (Object)dialog.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, "ok");
    }

    @Override
    protected void checkDeactivationConfirmation(IMObject object) {
        ConfirmationDialog dialog = EchoTestHelper.findWindowPane(ConfirmationDialog.class);
        Assert.assertNotNull((Object)dialog);
        String title = "Deactivate " + this.getDisplayName(object) + "?";
        String message = object.getName() + " has relationships and cannot be deleted.\n\nDo you want to deactivate it instead?";
        Assert.assertEquals((Object)title, (Object)dialog.getTitle());
        Assert.assertEquals((Object)message, (Object)dialog.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, "ok");
    }

    @Override
    protected void checkDeactivatedError(IMObject object) {
        ErrorDialog dialog = EchoTestHelper.findWindowPane(ErrorDialog.class);
        Assert.assertNotNull((Object)dialog);
        String message = this.getDisplayName(object) + " " + object.getName() + " cannot be deleted as it has relationships.\n\nIt is currently deactivated.";
        Assert.assertEquals((Object)"Error", (Object)dialog.getTitle());
        Assert.assertEquals((Object)message, (Object)dialog.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, "ok");
    }
}

