/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.clinician;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.clinician.ClinicianParticipationEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;

public class ClinicianParticipationEditorTestCase
extends AbstractAppTest {
    @Test
    public void testNewParticipation() {
        User clinician = TestHelper.createClinician();
        Act event = (Act)this.create("act.patientClinicalEvent", Act.class);
        LocalContext context = new LocalContext();
        context.setClinician(clinician);
        DefaultLayoutContext layoutContext = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        Participation participation1 = (Participation)this.create("participation.clinician", Participation.class);
        ClinicianParticipationEditor editor1 = new ClinicianParticipationEditor(participation1, event, (LayoutContext)layoutContext);
        Assert.assertEquals((Object)clinician, (Object)editor1.getEntity());
        Assert.assertTrue((boolean)editor1.isValid());
        clinician.setActive(false);
        this.save((IMObject)clinician);
        Assert.assertTrue((boolean)editor1.isValid());
        Participation participation2 = (Participation)this.create("participation.clinician", Participation.class);
        ClinicianParticipationEditor editor2 = new ClinicianParticipationEditor(participation2, event, (LayoutContext)layoutContext);
        Assert.assertNull((Object)editor2.getEntity());
        Assert.assertFalse((boolean)editor2.isValid());
        editor2.setEntity((Entity)clinician);
        Assert.assertEquals((Object)clinician, (Object)editor2.getEntity());
        Assert.assertTrue((boolean)editor2.isValid());
    }

    @Test
    public void testExistingParticipation() {
        User clinician1 = TestHelper.createClinician();
        User clinician2 = TestHelper.createClinician();
        Act event = PatientTestHelper.createEvent((Party)TestHelper.createPatient(), (User)clinician1);
        LocalContext context = new LocalContext();
        context.setClinician(clinician2);
        DefaultLayoutContext layoutContext = new DefaultLayoutContext((Context)context, new HelpContext("foo", null));
        Participation participation = (Participation)this.getArchetypeService().getBean((IMObject)event).getObject("clinician");
        Assert.assertNotNull((Object)participation);
        ClinicianParticipationEditor editor = new ClinicianParticipationEditor(participation, event, (LayoutContext)layoutContext);
        Assert.assertEquals((Object)clinician1, (Object)editor.getEntity());
    }
}

