/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.error;

import java.awt.print.PrinterException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import org.hibernate.exception.LockAcquisitionException;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.statement.StatementProcessorException;
import org.openvpms.component.business.service.archetype.ArchetypeServiceException;
import org.openvpms.component.business.service.archetype.ValidationException;
import org.openvpms.component.business.service.security.ArchetypeAccessDeniedException;
import org.openvpms.component.business.service.security.OpenVPMSAccessDeniedException;
import org.openvpms.report.ReportException;
import org.openvpms.report.i18n.ReportMessages;
import org.openvpms.report.openoffice.OpenOfficeConnectionException;
import org.openvpms.report.openoffice.OpenOfficeDocumentException;
import org.openvpms.web.component.error.ErrorReporterConfig;
import org.openvpms.web.component.error.ExceptionConfig;
import org.openvpms.web.component.im.query.QueryException;
import org.springframework.dao.CannotAcquireLockException;

public class ErrorReporterConfigTestCase {
    @Test
    public void testIsExcludedByCode() {
        ErrorReporterConfig config = new ErrorReporterConfig();
        ArchetypeServiceException a = new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToCreateObject);
        ArchetypeServiceException b = new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToExecuteQuery);
        ArchetypeServiceException c = new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToSaveObject);
        ValidationException d = new ValidationException("foo", Collections.emptyList());
        QueryException e = new QueryException(QueryException.ErrorCode.InvalidType, new Object[0]);
        Assert.assertFalse((boolean)config.isExcluded((Throwable)a));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)b));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)c));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)d));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)e));
        ExceptionConfig exception1Cfg = new ExceptionConfig(ArchetypeServiceException.class.getName());
        exception1Cfg.setCodes(Arrays.asList(ArchetypeServiceException.ErrorCode.FailedToSaveObject.toString(), ArchetypeServiceException.ErrorCode.FailedToExecuteQuery.toString()));
        ExceptionConfig exception3Cfg = new ExceptionConfig(ReportException.class.getName());
        ExceptionConfig cause = new ExceptionConfig(PrinterException.class.getName());
        exception3Cfg.setCauses(Collections.singletonList(cause));
        ExceptionConfig exception2Cfg = new ExceptionConfig(ValidationException.class.getName());
        config.setExcludes(Arrays.asList(exception1Cfg, exception2Cfg));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)a));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)b));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)c));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)d));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)e));
    }

    @Test
    public void testIsExcludedByMessage() {
        ErrorReporterConfig config = new ErrorReporterConfig();
        PrinterException a = new PrinterException("Printer is not accepting job.");
        PrinterException b = new PrinterException("Printer not found.");
        Assert.assertFalse((boolean)config.isExcluded((Throwable)a));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)b));
        ExceptionConfig exception = new ExceptionConfig(PrinterException.class.getName());
        exception.setMessages(Collections.singletonList("Printer is not accepting job."));
        config.setExcludes(Collections.singletonList(exception));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)a));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)b));
    }

    @Test
    public void testIsExcludedByCause() {
        ErrorReporterConfig config = new ErrorReporterConfig();
        ReportException a = new ReportException(ReportMessages.failedToGenerateReport((String)"foo", (String)"bar"));
        ReportException b = new ReportException(ReportMessages.failedToGenerateReport((String)"foo", (String)"bar"), (Throwable)new JRException((Throwable)new PrinterException("Printer is not accepting job.")));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)a));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)b));
        ExceptionConfig cause = new ExceptionConfig(PrinterException.class.getName());
        ExceptionConfig exception = new ExceptionConfig(ReportException.class.getName());
        exception.setCauses(Collections.singletonList(cause));
        config.setExcludes(Collections.singletonList(exception));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)a));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)b));
    }

    @Test
    public void testIsExcludedByCauseMessage() {
        ErrorReporterConfig config = new ErrorReporterConfig();
        ReportException a = new ReportException(ReportMessages.failedToGenerateReport((String)"foo", (String)"bar"));
        ReportException b = new ReportException(ReportMessages.failedToGenerateReport((String)"foo", (String)"bar"), (Throwable)new PrinterException("Printer is not accepting job."));
        ReportException c = new ReportException(ReportMessages.failedToGenerateReport((String)"foo", (String)"bar"), (Throwable)new PrinterException("Printer not found."));
        ReportException d = new ReportException(ReportMessages.failedToGenerateReport((String)"foo", (String)"bar"), (Throwable)new JRException((Throwable)new PrinterException("Invalid name of PrintService.")));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)a));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)b));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)c));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)d));
        ExceptionConfig cause = new ExceptionConfig(PrinterException.class.getName());
        cause.setMessages(Arrays.asList("Printer is not accepting job.", "Invalid name of PrintService."));
        ExceptionConfig exception = new ExceptionConfig(ReportException.class.getName());
        exception.setCauses(Collections.singletonList(cause));
        config.setExcludes(Collections.singletonList(exception));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)a));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)b));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)c));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)d));
    }

    @Test
    public void testWriteRead() {
        ErrorReporterConfig config = new ErrorReporterConfig();
        ExceptionConfig error1 = this.createConfig(ValidationException.class, new Enum[0]);
        ExceptionConfig error2 = this.createConfig(ArchetypeServiceException.class, new Enum[]{ArchetypeServiceException.ErrorCode.FailedToSaveObject, ArchetypeServiceException.ErrorCode.FailedToExecuteQuery});
        config.setExcludes(Arrays.asList(error1, error2));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        config.write((OutputStream)stream);
        ErrorReporterConfig read = ErrorReporterConfig.read((InputStream)new ByteArrayInputStream(stream.toByteArray()));
        List excludes = read.getExcludes();
        Assert.assertEquals((long)2L, (long)excludes.size());
        this.checkConfig(error1, (ExceptionConfig)excludes.get(0));
        this.checkConfig(error2, (ExceptionConfig)excludes.get(1));
    }

    @Test
    public void testDefaultConfig() {
        ErrorReporterConfig config = ErrorReporterConfig.read((InputStream)this.getClass().getResourceAsStream("/ErrorReporter.xml"));
        ValidationException ex1 = new ValidationException("foo", Collections.emptyList());
        OpenVPMSAccessDeniedException ex2 = new OpenVPMSAccessDeniedException(OpenVPMSAccessDeniedException.ErrorCode.AccessDenied);
        ReportException ex3 = new ReportException(ReportMessages.failedToFindSubReport((String)"foo", (String)"bar"));
        StatementProcessorException ex4 = new StatementProcessorException(StatementProcessorException.ErrorCode.InvalidConfiguration, new Object[0]);
        ReportException ex5 = new ReportException(ReportMessages.failedToGenerateReport((String)"foo", (String)"bar"), (Throwable)new JRException((Throwable)new PrinterException("Printer is not accepting job.")));
        ReportException ex6 = new ReportException(ReportMessages.failedToGenerateReport((String)"foo", (String)"bar"), (Throwable)new JRException((Throwable)new PrinterException("No printer found.")));
        ReportException ex7 = new ReportException(ReportMessages.failedToGenerateReport((String)"foo", (String)"bar"), (Throwable)new JRException("No suitable print service found."));
        ReportException ex8 = new ReportException(ReportMessages.failedToGenerateReport((String)"foo", (String)"bar"), (Throwable)new JRException((Throwable)new PrinterException("Invalid name of PrintService.")));
        ReportException ex9 = new ReportException(ReportMessages.failedToGenerateReport((String)"foo", (String)"bar"), (Throwable)new IllegalArgumentException("name"));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)ex1));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)ex2));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)ex3));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)ex4));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)ex5));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)ex6));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)ex7));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)ex8));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)ex9));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)new ArchetypeAccessDeniedException("foo", "save")));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)new OpenVPMSAccessDeniedException(OpenVPMSAccessDeniedException.ErrorCode.AccessDenied)));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)new OpenOfficeConnectionException(ReportMessages.failedToConnectToOpenOffice((String)"foo"))));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)new OpenOfficeDocumentException(ReportMessages.failedToLoadOpenOfficeDocument((String)"foo"))));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)new OutOfMemoryError()));
        NullPointerException inc1 = new NullPointerException();
        ReportException inc2 = new ReportException(ReportMessages.failedToCreateReport((String)"foo", (String)"bar"));
        StatementProcessorException inc3 = new StatementProcessorException(StatementProcessorException.ErrorCode.FailedToProcessStatement, new Object[0]);
        ReportException inc4 = new ReportException(ReportMessages.failedToGenerateReport((String)"foo", (String)"bar"), (Throwable)new JRException((Throwable)new PrinterException("Some error message.")));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)inc1));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)inc2));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)inc3));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)inc4));
    }

    @Test
    public void testIsExcludedByRootCause() {
        ErrorReporterConfig config = new ErrorReporterConfig();
        config.setExcludes(Arrays.asList(this.createConfig(NullPointerException.class, new Enum[0]), this.createConfig(CannotAcquireLockException.class, new Enum[0])));
        ArchetypeServiceException notExcluded = new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToCreateObject);
        ArchetypeServiceException excluded = new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToCreateObject, (Throwable)new NullPointerException());
        ArchetypeServiceException excluded2 = new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToDeleteObject, (Throwable)new CannotAcquireLockException("foo", (Throwable)new LockAcquisitionException("bar", new SQLException())));
        Assert.assertFalse((boolean)config.isExcluded((Throwable)notExcluded));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)excluded));
        Assert.assertTrue((boolean)config.isExcluded((Throwable)excluded2));
    }

    private void checkConfig(ExceptionConfig expected, ExceptionConfig actual) {
        Assert.assertEquals((Object)expected.getClassName(), (Object)actual.getClassName());
        Assert.assertEquals((Object)expected.getCodes(), (Object)actual.getCodes());
    }

    private ExceptionConfig createConfig(Class<?> exception, Enum<?> ... excludes) {
        ExceptionConfig config = new ExceptionConfig(exception.getName());
        ArrayList<String> list = new ArrayList<String>();
        for (Enum<?> exclude : excludes) {
            list.add(exclude.toString());
        }
        config.setCodes(list);
        return config;
    }
}

