/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import java.util.Calendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.web.component.bound.AbstractBoundFieldTest;
import org.openvpms.web.component.bound.BoundDateField;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;

public class BoundDateFieldTestCase
extends AbstractBoundFieldTest<BoundDateField, Date> {
    private static final Date value1 = java.sql.Date.valueOf("2009-01-01");
    private static final Date value2 = java.sql.Date.valueOf("2010-12-31");

    public BoundDateFieldTestCase() {
        super(value1, value2);
    }

    @Test
    public void testDateRange() {
        Property property = this.createProperty();
        BoundDateField field = this.createField(property);
        Date minDate = field.getMinDate();
        Date maxDate = field.getMaxDate();
        Assert.assertNotNull((Object)minDate);
        Assert.assertNotNull((Object)maxDate);
        Date belowMinDate = DateRules.getDate((Date)minDate, (int)-1, (DateUnits)DateUnits.DAYS);
        Date belowMaxDate = DateRules.getDate((Date)maxDate, (int)-1, (DateUnits)DateUnits.DAYS);
        Date aboveMaxDate = DateRules.getDate((Date)maxDate, (int)1, (DateUnits)DateUnits.DAYS);
        field.setDate(belowMinDate);
        Assert.assertNull((Object)property.getValue());
        Assert.assertFalse((boolean)property.isValid());
        field.setDate(minDate);
        Assert.assertEquals((Object)minDate, (Object)property.getValue());
        Assert.assertTrue((boolean)property.isValid());
        field.setDate(belowMaxDate);
        Assert.assertEquals((Object)belowMaxDate, (Object)property.getValue());
        Assert.assertTrue((boolean)property.isValid());
        field.setDate(maxDate);
        Assert.assertEquals((Object)belowMaxDate, (Object)property.getValue());
        Assert.assertFalse((boolean)property.isValid());
        field.setDate(aboveMaxDate);
        Assert.assertEquals((Object)belowMaxDate, (Object)property.getValue());
        Assert.assertFalse((boolean)property.isValid());
        field.setDate(belowMaxDate);
        Assert.assertEquals((Object)belowMaxDate, (Object)property.getValue());
        Assert.assertTrue((boolean)property.isValid());
    }

    @Override
    protected Date getValue(BoundDateField field) {
        return field.getSelectedDate().getTime();
    }

    @Override
    protected void setValue(BoundDateField field, Date value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        field.setSelectedDate(calendar);
    }

    @Override
    protected BoundDateField createField(Property property) {
        return new BoundDateField(property);
    }

    @Override
    protected Property createProperty() {
        return new SimpleProperty("date", Date.class);
    }
}

