/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.action;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.builder.practice.TestLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.Action;
import org.openvpms.web.component.action.ActionBuilder;
import org.openvpms.web.component.action.ActionStatus;
import org.openvpms.web.component.action.ListCallBuilder;
import org.openvpms.web.component.action.ObjectCallBuilder;
import org.openvpms.web.component.action.ObjectSupplier;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class ActionBuilderTestCase
extends AbstractAppTest {
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    @Test
    public void testRunnableAction() {
        MutableInt calls = new MutableInt();
        Runnable action = () -> ((MutableInt)calls).increment();
        ActionBuilder builder = this.newBuilder().action(action);
        this.verifyActionSucceeds(builder);
        Assert.assertEquals((long)1L, (long)calls.intValue());
    }

    @Test
    public void testObjectConsumerAction() {
        Party original = this.createStaleObject();
        MutableInt calls = new MutableInt();
        ActionBuilder builder = this.newBuilder().action((IMObject)original, ActionBuilder.asObject(party -> {
            calls.increment();
            party.setName("New Name");
            this.save((IMObject)party);
        }));
        this.verifyActionSucceeds(builder);
        Assert.assertEquals((Object)"New Name", (Object)((Party)this.get((IMObject)original)).getName());
        Assert.assertEquals((long)2L, (long)calls.intValue());
    }

    @Test
    public void testSupplierConsumerAction() {
        Party original = this.createStaleObject();
        MutableInt calls = new MutableInt();
        Supplier<Party> supplier = () -> original;
        ActionBuilder builder = this.newBuilder().action(original.getArchetype(), supplier, ActionBuilder.asObject(party -> {
            calls.increment();
            party.setName("New Name");
            this.save((IMObject)party);
        }));
        this.verifyActionSucceeds(builder);
        Assert.assertEquals((Object)"New Name", (Object)((Party)this.get((IMObject)original)).getName());
        Assert.assertEquals((long)2L, (long)calls.intValue());
    }

    @Test
    public void testObjectSupplierConsumerAction() {
        Party original = this.createStaleObject();
        MutableInt calls = new MutableInt();
        TestSupplier<Party> supplier = new TestSupplier<Party>(original);
        ActionBuilder builder = this.newBuilder().action(supplier, ActionBuilder.asObject(object -> {
            calls.increment();
            object.setName("New Name");
            this.save((IMObject)object);
        }));
        this.verifyActionSucceeds(builder);
        Assert.assertEquals((Object)"New Name", (Object)((Party)this.get((IMObject)original)).getName());
        Assert.assertEquals((long)2L, (long)calls.intValue());
    }

    @Test
    public void testObjectBeanAction() {
        Party location = this.createStaleObject();
        MutableInt calls = new MutableInt();
        ActionBuilder builder = this.newBuilder().action((IMObject)location, ActionBuilder.asBean(bean -> {
            calls.increment();
            bean.setValue("name", (Object)"New Name");
            bean.save();
        }));
        this.verifyActionSucceeds(builder);
        Assert.assertEquals((long)2L, (long)calls.intValue());
    }

    @Test
    public void testObjectSupplierBeanAction() {
        Party location = this.createStaleObject();
        TestSupplier<Party> supplier = new TestSupplier<Party>(location);
        MutableInt calls = new MutableInt();
        ActionBuilder builder = this.newBuilder().action(supplier, ActionBuilder.asBean(bean -> {
            calls.increment();
            bean.setValue("name", (Object)"New Name");
            bean.save();
        }));
        this.verifyActionSucceeds(builder);
        Assert.assertEquals((Object)"New Name", (Object)((Party)this.get((IMObject)location)).getName());
        Assert.assertEquals((long)2L, (long)calls.intValue());
    }

    @Test
    public void testUpdateAction() {
        Party location = this.createStaleObject();
        ActionBuilder builder = this.newBuilder().action((IMObject)location, ActionBuilder.update((String)"name", (Object)"New Name"));
        this.verifyActionSucceeds(builder);
        Assert.assertEquals((Object)"New Name", (Object)((Party)this.get((IMObject)location)).getName());
    }

    @Test
    public void testObjectChangedBeforeUpdate() {
        Party original = this.createStaleObject();
        Party reloaded = (Party)this.get((IMObject)original);
        Assert.assertEquals((Object)"Updated Name", (Object)reloaded.getName());
        Assert.assertEquals((Object)"Original Name", (Object)original.getName());
        Assert.assertTrue((reloaded.getVersion() > original.getVersion() ? 1 : 0) != 0);
        ActionBuilder builder = this.newBuilder().action((IMObject)original, ActionBuilder.update((String)"name", (Object)"New Name"));
        this.verifyActionSucceeds(builder);
        Party latest = (Party)this.get((IMObject)original);
        Assert.assertEquals((Object)"New Name", (Object)latest.getName());
    }

    @Test
    public void testWithObject() {
        Party original = this.createStaleObject();
        Party reloaded = (Party)this.get((IMObject)original);
        Assert.assertEquals((Object)"Updated Name", (Object)reloaded.getName());
        Assert.assertEquals((Object)"Original Name", (Object)original.getName());
        Assert.assertTrue((reloaded.getVersion() > original.getVersion() ? 1 : 0) != 0);
        ActionBuilder builder1 = this.newBuilder().withObject((IMObject)original).asBean(ActionBuilder.update((String)"name", (Object)"New Name"));
        this.verifyActionFails(builder1, "Practice Location has been changed by another user");
        this.checkUnchanged(reloaded);
        MutableInt calls2 = new MutableInt();
        ActionBuilder builder2 = ((ObjectCallBuilder)this.newBuilder().withObject((IMObject)original).useLatestInstanceOnRetry()).call(object -> {
            calls2.increment();
            object.setName("New Name 2");
            this.save((IMObject)object);
        });
        this.verifyActionSucceeds(builder2);
        Assert.assertEquals((long)2L, (long)calls2.intValue());
        Assert.assertEquals((Object)"New Name 2", (Object)((Party)this.get((IMObject)original)).getName());
        MutableInt calls3 = new MutableInt();
        ActionBuilder builder3 = ((ObjectCallBuilder)this.newBuilder().withObject((IMObject)original).useLatestInstance()).call(object -> {
            calls3.increment();
            object.setName("New Name 3");
            this.save((IMObject)object);
        });
        this.verifyActionSucceeds(builder3);
        Assert.assertEquals((long)1L, (long)calls3.intValue());
        Assert.assertEquals((Object)"New Name 3", (Object)((Party)this.get((IMObject)original)).getName());
        MutableInt calls4 = new MutableInt();
        ActionBuilder builder4 = ((ObjectCallBuilder)this.newBuilder().withObject((IMObject)original).skipIfChangedOrMissing()).call(object -> {
            calls4.increment();
            object.setName("New Name 4");
            this.save((IMObject)object);
        });
        this.verifyActionSkipped(builder4, "Practice Location has been changed by another user");
        Assert.assertEquals((long)1L, (long)calls4.intValue());
        Assert.assertEquals((Object)"New Name 3", (Object)((Party)this.get((IMObject)original)).getName());
        this.remove(this.get((IMObject)original));
        MutableInt calls5 = new MutableInt();
        ActionBuilder builder5 = ((ObjectCallBuilder)this.newBuilder().withObject((IMObject)original).failIfChangedOrMissing()).call(object -> {
            calls5.increment();
            object.setName("New Name 5");
            this.save((IMObject)object);
        });
        this.verifyActionFails(builder5, "Practice Location no longer exists");
        Assert.assertEquals((long)1L, (long)calls5.intValue());
    }

    @Test
    public void testWithSupplier() {
        Party original = this.createStaleObject();
        Party reloaded = (Party)this.get((IMObject)original);
        Assert.assertEquals((Object)"Updated Name", (Object)reloaded.getName());
        Assert.assertEquals((Object)"Original Name", (Object)original.getName());
        Assert.assertTrue((reloaded.getVersion() > original.getVersion() ? 1 : 0) != 0);
        String archetype = original.getArchetype();
        Supplier<Party> supplier = () -> original;
        ActionBuilder builder1 = this.newBuilder().withObject(archetype, supplier).asBean(ActionBuilder.update((String)"name", (Object)"New Name"));
        this.verifyActionFails(builder1, "Practice Location has been changed by another user");
        this.checkUnchanged(reloaded);
        MutableInt calls2 = new MutableInt();
        ActionBuilder builder2 = ((ObjectCallBuilder)this.newBuilder().withObject(archetype, supplier).useLatestInstanceOnRetry()).call(object -> {
            calls2.increment();
            object.setName("New Name 2");
            this.save((IMObject)object);
        });
        this.verifyActionSucceeds(builder2);
        Assert.assertEquals((long)2L, (long)calls2.intValue());
        Assert.assertEquals((Object)"New Name 2", (Object)((Party)this.get((IMObject)original)).getName());
        MutableInt calls3 = new MutableInt();
        ActionBuilder builder3 = ((ObjectCallBuilder)this.newBuilder().withObject(archetype, supplier).useLatestInstance()).call(object -> {
            calls3.increment();
            object.setName("New Name 3");
            this.save((IMObject)object);
        });
        this.verifyActionSucceeds(builder3);
        Assert.assertEquals((long)1L, (long)calls3.intValue());
        Assert.assertEquals((Object)"New Name 3", (Object)((Party)this.get((IMObject)original)).getName());
        MutableInt calls4 = new MutableInt();
        ActionBuilder builder4 = ((ObjectCallBuilder)this.newBuilder().withObject(archetype, supplier).skipIfChangedOrMissing()).call(object -> {
            calls4.increment();
            object.setName("New Name 4");
            this.save((IMObject)object);
        });
        this.verifyActionSkipped(builder4, "Practice Location has been changed by another user");
        Assert.assertEquals((long)1L, (long)calls4.intValue());
        Assert.assertEquals((Object)"New Name 3", (Object)((Party)this.get((IMObject)original)).getName());
        this.remove(this.get((IMObject)original));
        MutableInt calls5 = new MutableInt();
        ActionBuilder builder5 = ((ObjectCallBuilder)this.newBuilder().withObject(archetype, supplier).failIfChangedOrMissing()).call(object -> {
            calls5.increment();
            object.setName("New Name 5");
            this.save((IMObject)object);
        });
        this.verifyActionFails(builder5, "Practice Location no longer exists");
        Assert.assertEquals((long)1L, (long)calls5.intValue());
    }

    @Test
    public void testWithObjectSupplier() {
        Party original = this.createStaleObject();
        Party reloaded = (Party)this.get((IMObject)original);
        Assert.assertEquals((Object)"Updated Name", (Object)reloaded.getName());
        Assert.assertEquals((Object)"Original Name", (Object)original.getName());
        Assert.assertTrue((reloaded.getVersion() > original.getVersion() ? 1 : 0) != 0);
        TestSupplier<Party> supplier = new TestSupplier<Party>(original);
        ActionBuilder builder1 = this.newBuilder().withObject(supplier).asBean(ActionBuilder.update((String)"name", (Object)"New Name"));
        this.verifyActionFails(builder1, "Practice Location has been changed by another user");
        this.checkUnchanged(reloaded);
        MutableInt calls2 = new MutableInt();
        ActionBuilder builder2 = ((ObjectCallBuilder)this.newBuilder().withObject(supplier).useLatestInstanceOnRetry()).call(object -> {
            calls2.increment();
            object.setName("New Name 2");
            this.save((IMObject)object);
        });
        this.verifyActionSucceeds(builder2);
        Assert.assertEquals((long)2L, (long)calls2.intValue());
        Assert.assertEquals((Object)"New Name 2", (Object)((Party)this.get((IMObject)original)).getName());
        MutableInt calls3 = new MutableInt();
        ActionBuilder builder3 = ((ObjectCallBuilder)this.newBuilder().withObject(supplier).useLatestInstance()).call(object -> {
            calls3.increment();
            object.setName("New Name 3");
            this.save((IMObject)object);
        });
        this.verifyActionSucceeds(builder3);
        Assert.assertEquals((long)1L, (long)calls3.intValue());
        Assert.assertEquals((Object)"New Name 3", (Object)((Party)this.get((IMObject)original)).getName());
        MutableInt calls4 = new MutableInt();
        ActionBuilder builder4 = ((ObjectCallBuilder)this.newBuilder().withObject(supplier).skipIfChangedOrMissing()).call(object -> {
            calls4.increment();
            object.setName("New Name 4");
            this.save((IMObject)object);
        });
        this.verifyActionSkipped(builder4, "Practice Location has been changed by another user");
        Assert.assertEquals((long)1L, (long)calls4.intValue());
        Assert.assertEquals((Object)"New Name 3", (Object)((Party)this.get((IMObject)original)).getName());
        this.remove(this.get((IMObject)original));
        MutableInt calls5 = new MutableInt();
        ActionBuilder builder5 = ((ObjectCallBuilder)this.newBuilder().withObject(supplier).failIfChangedOrMissing()).call(object -> {
            calls5.increment();
            object.setName("New Name 5");
            this.save((IMObject)object);
        });
        this.verifyActionFails(builder5, "Practice Location no longer exists");
        Assert.assertEquals((long)1L, (long)calls5.intValue());
    }

    @Test
    public void testWithLatest() {
        Party original = this.createStaleObject();
        Party reloaded = (Party)this.get((IMObject)original);
        Assert.assertEquals((Object)"Updated Name", (Object)reloaded.getName());
        Assert.assertEquals((Object)"Original Name", (Object)original.getName());
        Assert.assertTrue((reloaded.getVersion() > original.getVersion() ? 1 : 0) != 0);
        MutableInt calls = new MutableInt();
        ActionBuilder builder = this.newBuilder().withLatest((IMObject)original).call(object -> {
            calls.increment();
            object.setName("New Name");
            this.save((IMObject)object);
        });
        this.verifyActionSucceeds(builder);
        Assert.assertEquals((long)1L, (long)calls.intValue());
        Assert.assertEquals((Object)"New Name", (Object)((Party)this.get((IMObject)original)).getName());
    }

    @Test
    public void testWithLatestSupplier() {
        Party original = this.createStaleObject();
        Party reloaded = (Party)this.get((IMObject)original);
        Assert.assertEquals((Object)"Updated Name", (Object)reloaded.getName());
        Assert.assertEquals((Object)"Original Name", (Object)original.getName());
        Assert.assertTrue((reloaded.getVersion() > original.getVersion() ? 1 : 0) != 0);
        String archetype = original.getArchetype();
        Supplier<Party> supplier = () -> original;
        MutableInt calls = new MutableInt();
        ActionBuilder builder = this.newBuilder().withLatest(archetype, supplier).call(object -> {
            calls.increment();
            object.setName("New Name");
            this.save((IMObject)object);
        });
        this.verifyActionSucceeds(builder);
        Assert.assertEquals((long)1L, (long)calls.intValue());
        Assert.assertEquals((Object)"New Name", (Object)((Party)this.get((IMObject)original)).getName());
    }

    @Test
    public void testWithLatestObjectSupplier() {
        Party original = this.createStaleObject();
        Party reloaded = (Party)this.get((IMObject)original);
        Assert.assertEquals((Object)"Updated Name", (Object)reloaded.getName());
        Assert.assertEquals((Object)"Original Name", (Object)original.getName());
        Assert.assertTrue((reloaded.getVersion() > original.getVersion() ? 1 : 0) != 0);
        TestSupplier<Party> supplier = new TestSupplier<Party>(original);
        MutableInt calls = new MutableInt();
        ActionBuilder builder = this.newBuilder().withLatest(supplier).call(object -> {
            calls.increment();
            object.setName("New Name");
            this.save((IMObject)object);
        });
        this.verifyActionSucceeds(builder);
        Assert.assertEquals((long)1L, (long)calls.intValue());
        Assert.assertEquals((Object)"New Name", (Object)((Party)this.get((IMObject)original)).getName());
    }

    @Test
    public void testWithObjects() {
        Party original1 = this.createStaleObject();
        Party original2 = this.createStaleObject();
        List<Party> objects = Arrays.asList(original1, original2);
        MutableInt calls1 = new MutableInt();
        ActionBuilder builder1 = this.newBuilder().withObjects(objects).call(list -> {
            calls1.increment();
            Assert.assertEquals((long)2L, (long)list.size());
            ((Party)list.get(0)).setName("New Name 1");
            ((Party)list.get(1)).setName("New Name 2");
            this.save((Collection)list);
        });
        this.verifyActionFails(builder1, "Practice Location has been changed by another user");
        Assert.assertEquals((long)1L, (long)calls1.intValue());
        Assert.assertEquals((Object)"Updated Name", (Object)((Party)this.get((IMObject)original1)).getName());
        Assert.assertEquals((Object)"Updated Name", (Object)((Party)this.get((IMObject)original2)).getName());
        MutableInt call2 = new MutableInt();
        ActionBuilder builder2 = ((ListCallBuilder)this.newBuilder().withObjects(objects).useLatestInstanceOnRetry()).call(list -> {
            call2.increment();
            Assert.assertEquals((long)2L, (long)list.size());
            ((Party)list.get(0)).setName("New Name 3");
            ((Party)list.get(1)).setName("New Name 4");
            this.save((Collection)list);
        });
        this.verifyActionSucceeds(builder2);
        Assert.assertEquals((long)2L, (long)call2.intValue());
        Assert.assertEquals((Object)"New Name 3", (Object)((Party)this.get((IMObject)original1)).getName());
        Assert.assertEquals((Object)"New Name 4", (Object)((Party)this.get((IMObject)original2)).getName());
        MutableInt call3 = new MutableInt();
        ActionBuilder builder3 = ((ListCallBuilder)this.newBuilder().withObjects(objects).useLatestInstance()).call(list -> {
            call3.increment();
            Assert.assertEquals((long)2L, (long)list.size());
            ((Party)list.get(0)).setName("New Name 5");
            ((Party)list.get(1)).setName("New Name 6");
            this.save((Collection)list);
        });
        this.verifyActionSucceeds(builder3);
        Assert.assertEquals((long)1L, (long)call3.intValue());
        Assert.assertEquals((Object)"New Name 5", (Object)((Party)this.get((IMObject)original1)).getName());
        Assert.assertEquals((Object)"New Name 6", (Object)((Party)this.get((IMObject)original2)).getName());
        MutableInt call4 = new MutableInt();
        ActionBuilder builder4 = ((ListCallBuilder)this.newBuilder().withObjects(objects).skipIfChangedOrMissing()).call(list -> {
            call4.increment();
            Assert.assertEquals((long)2L, (long)list.size());
            ((Party)list.get(0)).setName("New Name 7");
            ((Party)list.get(1)).setName("New Name 8");
            this.save((Collection)list);
        });
        this.verifyActionSkipped(builder4, "Practice Location has been changed by another user");
        Assert.assertEquals((long)1L, (long)call4.intValue());
        Assert.assertEquals((Object)"New Name 5", (Object)((Party)this.get((IMObject)original1)).getName());
        Assert.assertEquals((Object)"New Name 6", (Object)((Party)this.get((IMObject)original2)).getName());
        this.remove(this.get((IMObject)original1));
        MutableInt call5 = new MutableInt();
        ActionBuilder builder5 = ((ListCallBuilder)this.newBuilder().withObjects(objects).failIfChangedOrMissing()).call(list -> {
            call5.increment();
            Assert.assertEquals((long)2L, (long)list.size());
            ((Party)list.get(0)).setName("New Name 9");
            ((Party)list.get(1)).setName("New Name 10");
            this.save((Collection)list);
        });
        this.verifyActionFails(builder5, "Practice Location no longer exists");
        Assert.assertEquals((long)1L, (long)call5.intValue());
    }

    @Test
    public void testWithLatestObjects() {
        Party original1 = this.createStaleObject();
        Party original2 = this.createStaleObject();
        List<Party> objects = Arrays.asList(original1, original2);
        MutableInt calls = new MutableInt();
        ActionBuilder builder1 = this.newBuilder().withLatest(objects).call(list -> {
            calls.increment();
            Assert.assertEquals((long)2L, (long)list.size());
            ((Party)list.get(0)).setName("New Name 1");
            ((Party)list.get(1)).setName("New Name 2");
            this.save((Collection)list);
        });
        this.verifyActionSucceeds(builder1);
        Assert.assertEquals((long)1L, (long)calls.intValue());
        Assert.assertEquals((Object)"New Name 1", (Object)((Party)this.get((IMObject)original1)).getName());
        Assert.assertEquals((Object)"New Name 2", (Object)((Party)this.get((IMObject)original2)).getName());
    }

    @Test
    public void testObjectDeletedBeforeUpdate() {
        Party location = this.practiceFactory.createLocation();
        this.remove((IMObject)location);
        ActionBuilder builder = this.newBuilder().action((IMObject)location, ActionBuilder.update((String)"name", (Object)"New Name"));
        this.verifyActionFails(builder, "Practice Location no longer exists");
    }

    @Test
    public void testInteractiveRetry() {
        MutableInt calls = new MutableInt();
        MutableInt success = new MutableInt();
        MutableInt failure = new MutableInt();
        MutableInt skip = new MutableInt();
        MutableObject status = new MutableObject();
        Action action = this.newBuilder().action(() -> {
            if (calls.getAndIncrement() < 1) {
                throw new RuntimeException("Operation failed");
            }
        }).interactiveOnly().onSuccess(() -> ((MutableInt)success).increment()).onFailure(() -> ((MutableInt)failure).increment()).onSkip(() -> ((MutableInt)skip).increment()).build();
        action.run(arg_0 -> ((MutableObject)status).setValue(arg_0));
        EchoTestHelper.findMessageDialogAndFireButton(ErrorDialog.class, "Error", "Operation failed", "button.retry");
        this.checkSucceeded((ActionStatus)status.getValue());
        Assert.assertEquals((long)2L, (long)calls.intValue());
        Assert.assertEquals((long)1L, (long)success.intValue());
        Assert.assertEquals((long)0L, (long)failure.intValue());
        Assert.assertEquals((long)0L, (long)skip.intValue());
    }

    @Test
    public void testBackgroundRetry() {
        MutableInt calls = new MutableInt();
        MutableInt success = new MutableInt();
        MutableInt failure = new MutableInt();
        MutableInt skip = new MutableInt();
        MutableObject status = new MutableObject();
        Action action = this.newBuilder().action(() -> {
            if (calls.getAndIncrement() < 1) {
                throw new RuntimeException("Operation failed");
            }
        }).backgroundOnly().automaticRetry(1).delay(0L).onSuccess(() -> ((MutableInt)success).increment()).onFailure(() -> ((MutableInt)failure).increment()).onSkip(() -> ((MutableInt)skip).increment()).build();
        action.run(arg_0 -> ((MutableObject)status).setValue(arg_0));
        Assert.assertNull((Object)EchoTestHelper.findWindowPane(ErrorDialog.class));
        this.checkSucceeded((ActionStatus)status.getValue());
        Assert.assertEquals((long)2L, (long)calls.intValue());
        Assert.assertEquals((long)1L, (long)success.intValue());
        Assert.assertEquals((long)0L, (long)failure.intValue());
        Assert.assertEquals((long)0L, (long)skip.intValue());
    }

    @Test
    public void testAutomaticAndInteractiveRetry() {
        MutableInt calls = new MutableInt();
        MutableInt success = new MutableInt();
        MutableInt failure = new MutableInt();
        MutableInt skip = new MutableInt();
        MutableObject status = new MutableObject();
        Action action = this.newBuilder().action(() -> {
            if (calls.getAndIncrement() < 4) {
                throw new RuntimeException("Operation failed");
            }
        }).automaticRetry().interactiveRetry().onSuccess(() -> ((MutableInt)success).increment()).onFailure(() -> ((MutableInt)failure).increment()).onSkip(() -> ((MutableInt)skip).increment()).build();
        action.run(arg_0 -> ((MutableObject)status).setValue(arg_0));
        EchoTestHelper.findMessageDialogAndFireButton(ErrorDialog.class, "Error", "Operation failed", "button.retry");
        this.checkSucceeded((ActionStatus)status.getValue());
        Assert.assertEquals((long)5L, (long)calls.intValue());
        Assert.assertEquals((long)1L, (long)success.intValue());
        Assert.assertEquals((long)0L, (long)failure.intValue());
        Assert.assertEquals((long)0L, (long)skip.intValue());
    }

    @Test
    public void testInteractiveRetryCancellation() {
        MutableInt calls = new MutableInt();
        MutableInt success = new MutableInt();
        MutableInt failure = new MutableInt();
        MutableInt skip = new MutableInt();
        MutableObject status = new MutableObject();
        Action action = this.newBuilder().action(() -> {
            if (calls.getAndIncrement() < 1) {
                throw new RuntimeException("Operation failed");
            }
        }).interactiveOnly().onSuccess(() -> ((MutableInt)success).increment()).onFailure(() -> ((MutableInt)failure).increment()).onSkip(() -> ((MutableInt)skip).increment()).build();
        action.run(arg_0 -> ((MutableObject)status).setValue(arg_0));
        EchoTestHelper.findMessageDialogAndFireButton(ErrorDialog.class, "Error", "Operation failed", "cancel");
        this.checkFailed((ActionStatus)status.getValue(), "Operation failed");
        Assert.assertEquals((long)1L, (long)calls.intValue());
        Assert.assertEquals((long)0L, (long)success.intValue());
        Assert.assertEquals((long)1L, (long)failure.intValue());
        Assert.assertEquals((long)0L, (long)skip.intValue());
    }

    @Test
    public void testOnSuccessMethodFailure() {
        MutableInt calls = new MutableInt();
        MutableInt failure = new MutableInt();
        MutableInt skip = new MutableInt();
        MutableObject status = new MutableObject();
        Action action = this.newBuilder().action(() -> ((MutableInt)calls).increment()).onSuccess(() -> {
            throw new RuntimeException("Operation failed");
        }).onFailure(() -> ((MutableInt)failure).increment()).onSkip(() -> ((MutableInt)skip).increment()).build();
        action.run(arg_0 -> ((MutableObject)status).setValue(arg_0));
        this.checkFailed((ActionStatus)status.getValue(), "Operation failed");
        Assert.assertEquals((long)1L, (long)calls.intValue());
        Assert.assertEquals((long)0L, (long)failure.intValue());
        Assert.assertEquals((long)0L, (long)skip.intValue());
    }

    @Test
    public void testOnFailureMethodFailure() {
        MutableInt calls = new MutableInt();
        MutableInt success = new MutableInt();
        MutableInt failure = new MutableInt();
        MutableInt skip = new MutableInt();
        MutableObject status = new MutableObject();
        Action action = this.newBuilder().action(() -> {
            calls.increment();
            throw new RuntimeException("action() failed");
        }).onSuccess(() -> ((MutableInt)success).increment()).backgroundOnly().automaticRetry(0).onFailure(() -> {
            failure.increment();
            throw new RuntimeException("onFailure() operation failed");
        }).onSkip(() -> ((MutableInt)skip).increment()).build();
        action.run(arg_0 -> ((MutableObject)status).setValue(arg_0));
        this.checkFailed((ActionStatus)status.getValue(), "action() failed");
        Assert.assertEquals((long)1L, (long)calls.intValue());
        Assert.assertEquals((long)0L, (long)success.intValue());
        Assert.assertEquals((long)1L, (long)failure.intValue());
        Assert.assertEquals((long)0L, (long)skip.intValue());
    }

    @Test
    public void testOnSkipMethodFailure() {
        MutableInt calls = new MutableInt();
        MutableInt success = new MutableInt();
        MutableInt failure = new MutableInt();
        MutableInt skip = new MutableInt();
        MutableObject status = new MutableObject();
        Party object = this.createStaleObject();
        Action action = ((ObjectCallBuilder)this.newBuilder().withObject((IMObject)object).skipIfChangedOrMissing()).call(obj -> {
            calls.increment();
            obj.setName("New Name");
            this.save((IMObject)obj);
        }).onSuccess(() -> ((MutableInt)success).increment()).backgroundOnly().onFailure(() -> ((MutableInt)failure).increment()).onSkip(() -> {
            skip.increment();
            throw new RuntimeException("onSkip() operation failed");
        }).build();
        action.run(arg_0 -> ((MutableObject)status).setValue(arg_0));
        this.checkSkipped((ActionStatus)status.getValue(), "Practice Location has been changed by another user");
        Assert.assertEquals((long)1L, (long)calls.intValue());
        Assert.assertEquals((long)0L, (long)success.intValue());
        Assert.assertEquals((long)0L, (long)failure.intValue());
        Assert.assertEquals((long)1L, (long)skip.intValue());
    }

    @Test
    public void testRunOnce() {
        MutableInt calls = new MutableInt();
        MutableInt success = new MutableInt();
        MutableInt failure = new MutableInt();
        MutableInt skip = new MutableInt();
        MutableObject status = new MutableObject();
        this.newBuilder().action(() -> {
            calls.increment();
            throw new RuntimeException("action() failed");
        }).onSuccess(() -> ((MutableInt)success).increment()).onFailure(() -> ((MutableInt)failure).increment()).onSkip(() -> ((MutableInt)skip).increment()).runOnce(arg_0 -> ((MutableObject)status).setValue(arg_0));
        this.checkFailed((ActionStatus)status.getValue(), "action() failed");
        Assert.assertEquals((long)1L, (long)calls.intValue());
        Assert.assertEquals((long)0L, (long)success.intValue());
        Assert.assertEquals((long)1L, (long)failure.intValue());
        Assert.assertEquals((long)0L, (long)skip.intValue());
    }

    @Test
    public void testNoSuccessAction() {
        MutableInt calls = new MutableInt();
        MutableObject status = new MutableObject();
        this.newBuilder().action(() -> ((MutableInt)calls).increment()).run(arg_0 -> ((MutableObject)status).setValue(arg_0));
        this.checkSucceeded((ActionStatus)status.getValue());
        Assert.assertEquals((long)1L, (long)calls.intValue());
    }

    @Test
    public void testNoFailureAction() {
        MutableInt calls = new MutableInt();
        MutableObject status = new MutableObject();
        this.newBuilder().action(() -> {
            calls.increment();
            throw new RuntimeException("action() failed");
        }).backgroundOnly().automaticRetry(1).run(arg_0 -> ((MutableObject)status).setValue(arg_0));
        this.checkFailed((ActionStatus)status.getValue(), "action() failed");
        Assert.assertEquals((long)2L, (long)calls.intValue());
    }

    @Test
    public void testNoSkipAction() {
        Party object = this.createStaleObject();
        MutableInt calls = new MutableInt();
        MutableObject status = new MutableObject();
        ((ObjectCallBuilder)this.newBuilder().withObject((IMObject)object).skipIfChangedOrMissing()).call(obj -> {
            calls.increment();
            obj.setName("New Name");
            this.save((IMObject)obj);
        }).run(arg_0 -> ((MutableObject)status).setValue(arg_0));
        this.checkSkipped((ActionStatus)status.getValue(), "Practice Location has been changed by another user");
        Assert.assertEquals((long)1L, (long)calls.intValue());
    }

    @Test
    public void testSynchronousActionHasTransaction() {
        Assert.assertFalse((boolean)TransactionSynchronizationManager.isActualTransactionActive());
        Party object = this.createStaleObject();
        this.newBuilder().withLatest((IMObject)object).call(obj -> Assert.assertTrue((boolean)TransactionSynchronizationManager.isActualTransactionActive())).run(status -> Assert.assertFalse((boolean)TransactionSynchronizationManager.isActualTransactionActive()));
    }

    @Test
    public void testAsynchronousActionHasNoTransaction() {
        Assert.assertFalse((boolean)TransactionSynchronizationManager.isActualTransactionActive());
        Party object = this.createStaleObject();
        this.newBuilder().withLatest((IMObject)object).call((obj, listener) -> {
            Assert.assertFalse((boolean)TransactionSynchronizationManager.isActualTransactionActive());
            listener.accept(ActionStatus.success());
        }).run(status -> Assert.assertFalse((boolean)TransactionSynchronizationManager.isActualTransactionActive()));
    }

    private ActionBuilder newBuilder() {
        return new ActionBuilder((ArchetypeService)this.getArchetypeService(), this.transactionManager);
    }

    private void verifyActionSucceeds(ActionBuilder builder) {
        MutableInt success = new MutableInt();
        MutableInt failure = new MutableInt();
        MutableInt skip = new MutableInt();
        MutableObject status = new MutableObject();
        Action action = builder.onSuccess(() -> ((MutableInt)success).increment()).onFailure(() -> ((MutableInt)failure).increment()).onSkip(() -> ((MutableInt)skip).increment()).build();
        action.run(arg_0 -> ((MutableObject)status).setValue(arg_0));
        this.checkSucceeded((ActionStatus)status.getValue());
        Assert.assertEquals((long)1L, (long)success.intValue());
        Assert.assertEquals((long)0L, (long)failure.intValue());
        Assert.assertEquals((long)0L, (long)skip.intValue());
    }

    private void verifyActionFails(ActionBuilder builder, String message) {
        MutableInt success = new MutableInt();
        MutableInt failure = new MutableInt();
        MutableInt skip = new MutableInt();
        MutableObject status = new MutableObject();
        Action action = builder.onSuccess(() -> ((MutableInt)success).increment()).onFailure(() -> ((MutableInt)failure).increment()).onSkip(() -> ((MutableInt)skip).increment()).build();
        action.run(arg_0 -> ((MutableObject)status).setValue(arg_0));
        this.checkFailed((ActionStatus)status.getValue(), message);
        Assert.assertEquals((long)0L, (long)success.intValue());
        Assert.assertEquals((long)1L, (long)failure.intValue());
        Assert.assertEquals((long)0L, (long)skip.intValue());
    }

    private void verifyActionSkipped(ActionBuilder builder, String message) {
        MutableInt success = new MutableInt();
        MutableInt failure = new MutableInt();
        MutableInt skip = new MutableInt();
        MutableObject status = new MutableObject();
        Action action = builder.onSuccess(() -> ((MutableInt)success).increment()).onFailure(() -> ((MutableInt)failure).increment()).onSkip(() -> ((MutableInt)skip).increment()).build();
        action.run(arg_0 -> ((MutableObject)status).setValue(arg_0));
        this.checkSkipped((ActionStatus)status.getValue(), message);
        Assert.assertEquals((long)0L, (long)success.intValue());
        Assert.assertEquals((long)0L, (long)failure.intValue());
        Assert.assertEquals((long)1L, (long)skip.intValue());
    }

    private Party createStaleObject() {
        Party original = (Party)((TestLocationBuilder)this.practiceFactory.newLocation().name("Original Name")).build();
        ((TestLocationBuilder)this.practiceFactory.updateLocation((Party)this.get((IMObject)original)).name("Updated Name")).build();
        Party reloaded = (Party)this.get((IMObject)original);
        Assert.assertEquals((Object)"Updated Name", (Object)reloaded.getName());
        return original;
    }

    private void checkSucceeded(ActionStatus status) {
        this.checkStatus(status, true, null);
    }

    private void checkFailed(ActionStatus status, String message) {
        this.checkStatus(status, false, message);
    }

    private void checkSkipped(ActionStatus status, String message) {
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.skipped());
        Assert.assertFalse((boolean)status.succeeded());
        Assert.assertFalse((boolean)status.failed());
        Assert.assertEquals((Object)message, (Object)status.getMessage());
    }

    private void checkStatus(ActionStatus status, boolean succeeded, String message) {
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((Object)succeeded, (Object)status.succeeded());
        Assert.assertEquals((Object)(!succeeded ? 1 : 0), (Object)status.failed());
        Assert.assertEquals((Object)message, (Object)status.getMessage());
    }

    private void checkUnchanged(Party object) {
        Party latest = (Party)this.get((IMObject)object);
        Assert.assertEquals((long)object.getVersion(), (long)latest.getVersion());
    }

    private static class TestSupplier<T extends IMObject>
    implements ObjectSupplier<T> {
        private final T object;

        public TestSupplier(T object) {
            this.object = object;
        }

        public T get() {
            return this.object;
        }

        public String getArchetype() {
            return this.object.getArchetype();
        }
    }
}

