/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2021 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.component.im.account;

import org.openvpms.component.model.act.Act;
import org.openvpms.web.component.im.table.act.ActAmountTableModel;


/**
 * Account act table model.
 *
 * @author Tim Anderson
 */
public class AccountActTableModel<T extends Act> extends ActAmountTableModel<T> {

    /**
     * Constructs a {@link AccountActTableModel}.
     */
    public AccountActTableModel() {
        this(false);
    }

    /**
     * Constructs a {@link ActAmountTableModel}.
     *
     * @param showStatus determines if the status column should be displayed
     */
    public AccountActTableModel(boolean showStatus) {
        super(showStatus, true);
    }
}
