/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workspace;

import nextapp.echo2.app.Component;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.QueryBrowser;
import org.openvpms.web.component.workspace.AbstractCRUDWindow;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.component.workspace.QueryBrowserCRUDWorkspace;
import org.openvpms.web.component.workspace.ResultSetCRUDWindow;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.util.DoubleClickMonitor;

public abstract class ResultSetCRUDWorkspace<T extends IMObject>
extends QueryBrowserCRUDWorkspace<T, T> {
    private final DoubleClickMonitor click = new DoubleClickMonitor();

    public ResultSetCRUDWorkspace(String id, Context context) {
        super(id, context, false);
    }

    @Override
    public void setIMObject(IMObject object) {
        boolean select = object != null && object == this.getObject();
        super.setIMObject(object);
        if (select) {
            this.select((IMObject)this.getType().cast(object));
        }
    }

    @Override
    public void setObject(T object) {
        super.setObject(object);
        this.select(object);
    }

    protected void select(T object) {
        CRUDWindow window = this.getCRUDWindow();
        ((AbstractCRUDWindow)window).setObject(object);
        if (object != null) {
            Browser browser = this.getBrowser();
            browser.getQuery().setValue(object.getName());
            browser.query();
            this.updateResultSet();
            if (!browser.getObjects().isEmpty()) {
                browser.setSelected(object);
                ((ResultSetCRUDWindow)window).view();
            }
        }
    }

    @Override
    protected Component createWorkspace() {
        Component window = ((AbstractCRUDWindow)this.getCRUDWindow()).getComponent();
        Component browser = this.getBrowser().getComponent();
        return SplitPaneFactory.create((int)6, (String)"SplitPaneWithButtonRow", (Component[])new Component[]{window, browser});
    }

    @Override
    protected CRUDWindow<T> createCRUDWindow() {
        Browser browser = this.getBrowser();
        return new ResultSetCRUDWindow(this.getArchetypes(), browser.getQuery(), browser.getResultSet(), this.getContext(), this.getHelpContext());
    }

    @Override
    protected ResultSetCRUDWindow<T> getCRUDWindow() {
        return (ResultSetCRUDWindow)super.getCRUDWindow();
    }

    @Override
    protected QueryBrowser<T> getBrowser() {
        return (QueryBrowser)super.getBrowser();
    }

    @Override
    protected void onBrowserSelected(T object) {
        this.updateResultSet();
        super.onBrowserSelected(object);
        CRUDWindow window = this.getCRUDWindow();
        if (this.click.isDoubleClick((Object)object.getId())) {
            if (((AbstractCRUDWindow)window).canEdit()) {
                ((AbstractCRUDWindow)window).edit();
            } else {
                ((ResultSetCRUDWindow)window).view();
            }
        }
    }

    @Override
    protected void onBrowserViewed(T object) {
        this.updateResultSet();
        super.onBrowserViewed(object);
    }

    @Override
    protected void onSaved(T object, boolean isNew) {
        super.onSaved(object, isNew);
        this.updateResultSet();
    }

    @Override
    protected void onDeleted(T object) {
        super.onDeleted(object);
        this.updateResultSet();
    }

    @Override
    protected void onRefresh(T object) {
        super.onRefresh(object);
        this.updateResultSet();
    }

    @Override
    protected void onBrowserQuery() {
        super.onBrowserQuery();
        this.updateResultSet();
    }

    @Override
    protected boolean isParentOptional() {
        return true;
    }

    @Override
    protected void setArchetypes(Archetypes<T> archetypes) {
        super.setArchetypes(archetypes);
        this.setChildArchetypes(archetypes);
    }

    protected void updateResultSet() {
        Browser browser = this.getBrowser();
        CRUDWindow window = this.getCRUDWindow();
        ((ResultSetCRUDWindow)window).setQuery(browser.getQuery());
        ((ResultSetCRUDWindow)window).setResultSet(browser.getResultSet());
    }

    protected boolean updateArchetypes(String ... archetypes) {
        Archetypes latest;
        boolean updated = false;
        Archetypes existing = this.getArchetypes();
        if (!existing.equals(latest = Archetypes.create(archetypes, existing.getType(), existing.getDefaultShortName(), existing.getDisplayName()))) {
            this.setArchetypes(latest);
            updated = true;
        }
        return updated;
    }
}

