/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workspace;

import java.util.List;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.DefaultIMObjectActions;
import org.openvpms.web.component.im.edit.EditResultSetDialog;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.query.AbstractArchetypeQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.view.Selection;
import org.openvpms.web.component.im.view.ViewResultSetDialog;
import org.openvpms.web.component.workspace.AbstractCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.focus.FocusCommand;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;

public class ResultSetCRUDWindow<T extends IMObject>
extends AbstractCRUDWindow<T> {
    public static final String VIEW_ID = "view";
    private ResultSet<T> set;
    private Query<T> query;

    public ResultSetCRUDWindow(Archetypes<T> archetypes, Query<T> query, ResultSet<T> set, Context context, HelpContext help) {
        this(archetypes, DefaultIMObjectActions.getInstance(), query, set, context, help);
    }

    public ResultSetCRUDWindow(Archetypes<T> archetypes, IMObjectActions<T> actions, Query<T> query, ResultSet<T> set, Context context, HelpContext help) {
        super(archetypes, actions, context, help);
        this.setResultSet(set);
        this.setQuery(query);
    }

    public void setQuery(Query<T> query) {
        this.query = query;
    }

    public Query<T> getQuery() {
        return this.query;
    }

    public void setResultSet(ResultSet<T> set) {
        this.set = set;
        boolean enable = this.getObject() != null && set != null;
        this.createViewButton().setEnabled(enable);
    }

    public ResultSet<T> getResultSet() {
        return this.set;
    }

    public void view() {
        Object object = this.getObject();
        if (object != null && this.set != null) {
            final FocusCommand focus = new FocusCommand();
            String title = this.getDisplayName((IMObject)object);
            boolean edit = this.canEdit();
            final ViewResultSetDialog dialog = this.createViewResultSetDialog(title, object, edit);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onAction(String action) {
                    Object selected;
                    if ("edit".equals(action) && (selected = dialog.getSelected()) != null) {
                        ResultSetCRUDWindow.this.edit(selected, dialog.getSelectionPath());
                    }
                }

                protected void onAction(PopupDialog dialog2) {
                    focus.restore();
                    super.onAction(dialog2);
                }
            });
            dialog.show();
        }
    }

    protected ViewResultSetDialog<T> createViewResultSetDialog(String title, T object, boolean edit) {
        return new IMObjectViewResultSetDialog(this, title, object, edit);
    }

    @Override
    protected void onCreate(Archetypes<T> archetypes) {
        String selected;
        if (this.query != null && this.query instanceof AbstractArchetypeQuery && (selected = ((AbstractArchetypeQuery)this.query).getShortName()) != null) {
            archetypes = Archetypes.create(archetypes.getShortNames(), archetypes.getType(), selected, archetypes.getDisplayName());
        }
        super.onCreate(archetypes);
    }

    @Override
    protected void edit(T object, List<Selection> path) {
        if (object.isNew()) {
            super.edit(object, path);
        } else if (this.set != null) {
            final FocusCommand focus = new FocusCommand();
            String title = Messages.format((String)"editor.edit.title", (Object[])new Object[]{this.getArchetypes().getDisplayName()});
            EditResultSetDialog<T> dialog = this.createEditResultSetDialog(object, title);
            if (path != null) {
                IMObjectEditor editor = dialog.getEditor();
                editor.setSelectionPath(path);
            }
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener((IMObject)object){
                final /* synthetic */ IMObject val$object;
                {
                    this.val$object = iMObject;
                }

                protected void onAction(PopupDialog dialog) {
                    focus.restore();
                    super.onAction(dialog);
                    ResultSetCRUDWindow.this.onRefresh(this.val$object);
                }
            });
            dialog.show();
        }
    }

    protected EditResultSetDialog<T> createEditResultSetDialog(T object, String title) {
        return new EditResultSetDialog<T>(title, object, this.set, this.getActions(), this.getContext(), this.getHelpContext());
    }

    @Override
    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(this.createViewButton(), 1);
    }

    @Override
    protected void enableButtons(ButtonSet buttons, boolean enable) {
        boolean enableViewEdit = enable && this.set != null;
        IMObjectActions actions = this.getActions();
        buttons.setEnabled("button.new", actions.canCreate());
        buttons.setEnabled(VIEW_ID, enableViewEdit);
        buttons.setEnabled("button.edit", enableViewEdit && actions.canEdit(this.getObject()));
        buttons.setEnabled("button.delete", enable && actions.canDelete(this.getObject()));
    }

    protected Button createViewButton() {
        return ButtonFactory.create((String)VIEW_ID, this::view);
    }

    protected class IMObjectViewResultSetDialog
    extends ViewResultSetDialog<T> {
        final /* synthetic */ ResultSetCRUDWindow this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public IMObjectViewResultSetDialog(String title, T object, boolean edit) {
            this.this$0 = (ResultSetCRUDWindow)this$0;
            super(title, object, ((ResultSetCRUDWindow)this$0).set, edit, this$0.getContext(), this$0.getHelpContext());
        }

        @Override
        protected void view(T object, List<Selection> path) {
            this.setTitle(this.this$0.getDisplayName((IMObject)object));
            super.view(object, path);
        }
    }
}

