/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workspace;

import nextapp.echo2.app.Component;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserState;
import org.openvpms.web.component.workspace.AbstractCRUDWindow;
import org.openvpms.web.component.workspace.BrowserCRUDWindow;
import org.openvpms.web.component.workspace.TabComponent;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.help.HelpContext;

public class BrowserCRUDWindowTab<T extends IMObject>
extends BrowserCRUDWindow<T>
implements TabComponent {
    private final boolean refreshOnShow;

    public BrowserCRUDWindowTab(Browser<T> browser, AbstractCRUDWindow<T> window) {
        this(browser, window, true);
    }

    public BrowserCRUDWindowTab(Browser<T> browser, AbstractCRUDWindow<T> window, boolean refreshOnShow) {
        this(browser, window, refreshOnShow, true);
    }

    public BrowserCRUDWindowTab(Browser<T> browser, AbstractCRUDWindow<T> window, boolean refreshOnShow, boolean trackClick) {
        super(browser, window, trackClick);
        this.refreshOnShow = refreshOnShow;
    }

    @Override
    public void show() {
        if (this.refreshOnShow) {
            Browser<IMObject> browser = this.getBrowser();
            BrowserState state = browser.getBrowserState();
            if (state != null) {
                browser.setBrowserState(state);
            } else {
                IMObject selected = (IMObject)browser.getSelected();
                browser.query();
                if (selected != null) {
                    browser.setSelected(selected);
                }
                browser.setFocusOnResults();
            }
        }
    }

    @Override
    public Component getComponent() {
        return SplitPaneFactory.create((int)5, (String)"BrowserCRUDWorkspace.Layout", (Component[])new Component[]{this.getBrowser().getComponent(), this.getWindow().getComponent()});
    }

    @Override
    public HelpContext getHelpContext() {
        return this.getWindow().getHelpContext();
    }

    @Override
    protected void onQuery() {
        IMObject selected = (IMObject)this.getBrowser().getSelected();
        this.setSelected(selected);
    }
}

