/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workspace;

import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.query.BrowserFactory;
import org.openvpms.web.component.im.query.BrowserStates;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryFactory;
import org.openvpms.web.component.im.select.RepeatSelector;
import org.openvpms.web.component.workspace.AbstractWorkspace;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;

public abstract class AbstractViewWorkspace<T extends IMObject>
extends AbstractWorkspace<T> {
    private Archetypes<T> archetypes;
    private RepeatSelector<T> selector;
    private SplitPane root;

    public AbstractViewWorkspace(String id, Context context) {
        this(id, null, context);
    }

    public AbstractViewWorkspace(String id, Archetypes<T> archetypes, Context context) {
        this(id, archetypes, context, true);
    }

    public AbstractViewWorkspace(String id, Archetypes<T> archetypes, Context context, boolean showSelector) {
        super(id, context);
        this.archetypes = archetypes;
        if (showSelector) {
            this.selector = this.createSelector();
        }
    }

    @Override
    public void setObject(T object) {
        super.setObject(object);
        if (this.selector != null) {
            this.selector.setObject(object);
            this.updateSelector();
        }
    }

    @Override
    public boolean canUpdate(String shortName) {
        return this.archetypes.contains(shortName);
    }

    @Override
    public void show() {
        super.show();
        this.updateSelector();
    }

    @Override
    protected Class<T> getType() {
        return this.archetypes.getType();
    }

    protected void setArchetypes(Archetypes<T> archetypes) {
        this.archetypes = archetypes;
    }

    protected void setArchetypes(Class<T> type, String ... shortNames) {
        String key = this.getId() + ".type";
        this.setArchetypes(Archetypes.create(shortNames, type, Messages.get((String)key)));
    }

    protected Archetypes<T> getArchetypes() {
        return this.archetypes;
    }

    @Override
    protected Component doLayout() {
        this.root = this.createRootComponent();
        Component heading = this.createHeading();
        Column top = ColumnFactory.create((Component[])new Component[]{heading});
        if (this.selector != null) {
            Component select = this.selector.getComponent();
            Row wrapper = RowFactory.create((String)"AbstractViewWorkspace.Selector", (Component[])new Component[]{select});
            top.add((Component)wrapper);
        }
        this.root.add((Component)top);
        this.doLayout((Component)this.root);
        return this.root;
    }

    protected SplitPane getRootComponent() {
        if (this.root == null) {
            this.root = this.createRootComponent();
        }
        return this.root;
    }

    protected SplitPane createRootComponent() {
        int orientation = 5;
        String style = this.selector != null ? "AbstractViewWorkspace.Layout" : "AbstractViewWorkspace.LayoutNoSelector";
        return SplitPaneFactory.create((int)orientation, (String)style, (Component[])new Component[0]);
    }

    protected abstract void doLayout(Component var1);

    protected void onSelect() {
        HelpContext select = this.getHelpContext().subtopic("select");
        Browser<T> browser = this.createSelectBrowser(select);
        this.onSelect(browser, select);
    }

    protected void onSelectAgain() {
        HelpContext select = this.getHelpContext().subtopic("select");
        Browser<T> browser = this.createSelectBrowser(select);
        BrowserStates states = BrowserStates.getInstance();
        states.setBrowserState(browser);
        this.onSelect(browser, select);
    }

    protected void onSelectClosed(BrowserDialog<T> dialog) {
        IMObject object = (IMObject)dialog.getSelected();
        if (object != null) {
            this.onSelected(object);
        }
    }

    protected void onSelected(T object) {
        this.setObject(object);
    }

    protected BrowserDialog<T> createBrowserDialog(Browser<T> browser, HelpContext help) {
        String title = Messages.format((String)"imobject.select.title", (Object[])new Object[]{this.getArchetypes().getDisplayName()});
        return new BrowserDialog<T>(title, browser, help);
    }

    protected Browser<T> createSelectBrowser(HelpContext help) {
        return BrowserFactory.create(this.createSelectQuery(), new DefaultLayoutContext(this.getContext(), help));
    }

    protected Query<T> createSelectQuery() {
        return QueryFactory.create(this.getArchetypes().getShortNames(), this.getContext(), this.getType());
    }

    private RepeatSelector<T> createSelector() {
        RepeatSelector selector = new RepeatSelector();
        selector.getSelect().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent actionEvent) {
                AbstractViewWorkspace.this.onSelect();
            }
        });
        selector.getSelectAgain().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                AbstractViewWorkspace.this.onSelectAgain();
            }
        });
        return selector;
    }

    private void updateSelector() {
        BrowserStates states;
        if (this.selector != null && !this.selector.isShowSelectAgain() && (states = BrowserStates.getInstance()).exists(this.getArchetypes().getType(), this.getArchetypes().getShortNames())) {
            this.selector.setShowSelectAgain(true);
        }
    }

    private void onSelect(Browser<T> browser, HelpContext help) {
        final BrowserDialog<T> popup = this.createBrowserDialog(browser, help);
        popup.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                AbstractViewWorkspace.this.onSelectClosed(popup);
            }
        });
        popup.show();
    }
}

