/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workspace;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.button.AbstractButton;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.app.ProtectedLocationContext;
import org.openvpms.web.component.app.UserMailContext;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.delete.AbstractIMObjectDeletionListener;
import org.openvpms.web.component.im.delete.ConfirmingDeleter;
import org.openvpms.web.component.im.delete.IMObjectDeleter;
import org.openvpms.web.component.im.doc.DocumentJobManager;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.EditDialogFactory;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.print.InteractiveIMPrinter;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.Reporter;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.im.util.IMObjectCreatorListener;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.view.Selection;
import org.openvpms.web.component.job.Job;
import org.openvpms.web.component.job.JobBuilder;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.MailDialog;
import org.openvpms.web.component.mail.MailDialogFactory;
import org.openvpms.web.component.mail.MailEditor;
import org.openvpms.web.component.print.Printer;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.component.workspace.CRUDWindowListener;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public abstract class AbstractCRUDWindow<T extends IMObject>
implements CRUDWindow<T> {
    public static final String EDIT_ID = "button.edit";
    public static final String NEW_ID = "button.new";
    public static final String DELETE_ID = "button.delete";
    public static final String PRINT_ID = "button.print";
    public static final String MAIL_ID = "button.mail";
    private final Archetypes<T> archetypes;
    private final Context context;
    private final HelpContext help;
    private T object;
    private List<Selection> selectionPath;
    private IMObjectActions<T> actions;
    private CRUDWindowListener<T> listener;
    private Component component;
    private ButtonSet buttons;
    private MailContext mailContext;

    public AbstractCRUDWindow(Archetypes<T> archetypes, IMObjectActions<T> actions, Context context, HelpContext help) {
        this.archetypes = archetypes;
        this.actions = actions;
        this.context = context;
        this.help = help;
    }

    @Override
    public void setListener(CRUDWindowListener<T> listener) {
        this.listener = listener;
    }

    @Override
    public CRUDWindowListener<T> getListener() {
        return this.listener;
    }

    @Override
    public Component getComponent() {
        if (this.component == null) {
            this.component = this.doLayout();
        }
        return this.component;
    }

    @Override
    public void setObject(T object) {
        this.object = object;
        this.selectionPath = null;
        this.context.setCurrent((IMObject)object);
        this.getComponent();
        ButtonSet buttons = this.getButtons();
        if (buttons != null) {
            this.enableButtons(buttons, object != null);
        }
    }

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public void setSelectionPath(List<Selection> path) {
        this.selectionPath = path;
    }

    @Override
    public ArchetypeDescriptor getArchetypeDescriptor() {
        T object = this.getObject();
        ArchetypeDescriptor archetype = null;
        if (object != null) {
            archetype = DescriptorHelper.getArchetypeDescriptor(object, (ArchetypeService)this.getService());
        }
        return archetype;
    }

    @Override
    public void create() {
        if (this.actions.canCreate()) {
            this.onCreate(this.getArchetypes());
        }
    }

    @Override
    public boolean canEdit() {
        return this.canEdit(this.object);
    }

    @Override
    public void edit() {
        this.edit(this.selectionPath);
    }

    @Override
    public void edit(List<Selection> path) {
        T object = this.getObject();
        if (object != null) {
            T previous = object;
            if (!object.isNew()) {
                object = IMObjectHelper.reload(object);
            }
            if (object != null) {
                if (this.canEdit(object)) {
                    this.edit(object, path);
                } else {
                    ErrorHelper.show(Messages.format((String)"imobject.noedit", (Object[])new Object[]{this.getDisplayName((IMObject)object)}));
                    this.onRefresh(object);
                }
            } else {
                ErrorHelper.show(Messages.format((String)"imobject.noexist", (Object[])new Object[]{this.getDisplayName((IMObject)previous)}));
                this.onRefresh(previous);
            }
        }
    }

    public void delete() {
        T object = IMObjectHelper.reload(this.getObject());
        if (object == null) {
            ErrorHelper.show(Messages.format((String)"imobject.noexist", (Object[])new Object[]{this.archetypes.getDisplayName()}));
            this.onRefresh(this.getObject());
        } else if (this.getActions().canDelete(object)) {
            this.delete(object);
        } else {
            this.deleteDisallowed(object);
        }
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public void setMailContext(MailContext context) {
        this.mailContext = context;
    }

    @Override
    public MailContext getMailContext() {
        return this.mailContext;
    }

    @Override
    public HelpContext getHelpContext() {
        return this.help;
    }

    public void setButtons(ButtonSet buttons) {
        this.buttons = buttons;
        this.layoutButtons(buttons);
        this.enableButtons(buttons, this.getObject() != null);
    }

    public void refreshButtons() {
        if (this.buttons != null) {
            this.buttons.removeAll();
            this.layoutButtons(this.buttons);
            this.enableButtons(this.buttons, this.getObject() != null);
        }
    }

    protected IArchetypeRuleService getService() {
        return ServiceHelper.getArchetypeService();
    }

    protected Archetypes<T> getArchetypes() {
        return this.archetypes;
    }

    protected void setActions(IMObjectActions<T> actions) {
        this.actions = actions;
    }

    protected IMObjectActions<T> getActions() {
        return this.actions;
    }

    protected IMObjectDeleter<T> getDeleter() {
        return ServiceHelper.getBean(ConfirmingDeleter.class);
    }

    protected Component doLayout() {
        return this.layoutButtons();
    }

    protected Component layoutButtons() {
        if (this.buttons == null) {
            ButtonRow row = new ButtonRow("ControlRow");
            this.buttons = row.getButtons();
        }
        this.buttons.setHideDisabled(true);
        this.layoutButtons(this.buttons);
        this.enableButtons(this.buttons, false);
        return this.buttons.getContainer();
    }

    protected void layoutButtons(ButtonSet buttons) {
        buttons.add(this.createNewButton());
        buttons.add(this.createEditButton());
        buttons.add(this.createDeleteButton());
    }

    protected Button createEditButton() {
        return ButtonFactory.create((String)EDIT_ID, () -> {
            if (this.canEdit()) {
                this.edit();
            }
        });
    }

    protected Button createNewButton() {
        return ButtonFactory.create((String)NEW_ID, this::create);
    }

    protected Button createDeleteButton() {
        return ButtonFactory.create((String)DELETE_ID, this::delete);
    }

    protected Button createPrintButton() {
        return ButtonFactory.create((String)PRINT_ID, this::onPrint);
    }

    protected Button createMailButton() {
        return ButtonFactory.create((String)MAIL_ID, this::onMail);
    }

    protected ButtonSet getButtons() {
        return this.buttons;
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        T object = this.getObject();
        buttons.setEnabled(NEW_ID, this.actions.canCreate());
        buttons.setEnabled(EDIT_ID, enable && this.actions.canEdit(object));
        buttons.setEnabled(DELETE_ID, enable && this.actions.canDelete(object));
    }

    protected void enablePrintPreview(ButtonSet buttons, boolean enable) {
        buttons.setEnabled(PRINT_ID, enable);
        buttons.setEnabled(MAIL_ID, enable);
        String tooltip = null;
        if (enable) {
            buttons.addKeyListener(4182, (nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    AbstractCRUDWindow.this.onPreview();
                }
            });
            tooltip = Messages.get((String)"print.preview.tooltip");
        } else {
            buttons.removeKeyListener(4182);
        }
        AbstractButton button = this.getButtons().getButton(PRINT_ID);
        if (button != null) {
            button.setToolTipText(tooltip);
        }
    }

    protected void onCreate(Archetypes<T> archetypes) {
        IMObjectCreatorListener listener = new IMObjectCreatorListener(){

            @Override
            public void created(IMObject object) {
                AbstractCRUDWindow.this.onCreated(object);
            }

            @Override
            public void cancelled() {
            }
        };
        HelpContext help = this.getHelpContext().subtopic("new");
        IMObjectCreator.create(archetypes, listener, help);
    }

    protected void onCreated(T object) {
        this.edit(object, null);
    }

    protected boolean canEdit(T object) {
        boolean edit = false;
        if (this.actions.canEdit(object)) {
            ButtonSet buttons = this.getButtons();
            edit = buttons != null && buttons.isEnabled(EDIT_ID);
        }
        return edit;
    }

    protected void edit(T object, List<Selection> path) {
        try {
            HelpContext edit = this.createEditTopic((IMObject)object);
            LayoutContext context = this.createLayoutContext(edit);
            IMObjectEditor editor = this.createEditor(object, context);
            editor.getComponent();
            this.edit(editor, path);
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show(exception);
        }
    }

    protected void delete(T object) {
        IMObjectDeleter<T> deleter = this.getDeleter();
        HelpContext delete = this.getHelpContext().subtopic("delete");
        LocalContext local = new LocalContext(this.context);
        deleter.delete(object, local, delete, new AbstractIMObjectDeletionListener<T>(){

            @Override
            public void deleted(T object) {
                AbstractCRUDWindow.this.onDeleted(object);
            }

            @Override
            public void deactivated(T object) {
                AbstractCRUDWindow.this.onSaved(object, false);
            }
        });
    }

    protected void deleteDisallowed(T object) {
    }

    protected HelpContext createEditTopic(IMObject object) {
        return this.help.topic(object, "edit");
    }

    protected HelpContext createPrintTopic(IMObject object) {
        return this.help.topic(object, "print");
    }

    protected EditDialog edit(IMObjectEditor editor) {
        return this.edit(editor, (List<Selection>)null);
    }

    protected EditDialog edit(final IMObjectEditor editor, List<Selection> path) {
        IMObject object = editor.getObject();
        final boolean isNew = object.isNew();
        EditDialog dialog = this.createEditDialog(editor);
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                AbstractCRUDWindow.this.onEditCompleted(editor, isNew);
            }
        });
        this.context.setCurrent(object);
        dialog.show();
        if (path != null) {
            editor.setSelectionPath(path);
        }
        return dialog;
    }

    protected void onPrint() {
        this.run(this::print, this.getObject(), "printdialog.title");
    }

    protected void onMail() {
        this.run(this::mail, this.getObject(), "mail.title");
    }

    protected IMObjectEditor createEditor(T object, LayoutContext context) {
        return context.getEditorFactory().create((IMObject)object, context);
    }

    protected EditDialog createEditDialog(IMObjectEditor editor) {
        return ServiceHelper.getBean(EditDialogFactory.class).create(editor, this.context);
    }

    protected void onEditCompleted(IMObjectEditor editor, boolean isNew) {
        if (editor.isDeleted()) {
            this.onDeleted(editor.getObject());
        } else if (editor.isSaved() && !editor.isCancelled()) {
            this.onSaved(editor, isNew);
        } else {
            this.onRefresh(editor);
        }
    }

    protected void onSaved(IMObjectEditor editor, boolean isNew) {
        this.onSaved(editor.getObject(), isNew);
        this.setSelectionPath(editor.getSelectionPath());
    }

    protected void onSaved(T object, boolean isNew) {
        this.setObject(object);
        if (this.listener != null) {
            this.listener.saved(object, isNew);
        }
    }

    protected void onDeleted(T object) {
        this.setObject(null);
        if (this.listener != null) {
            this.listener.deleted(object);
        }
    }

    protected IMPrinter<T> createPrinter(T object) {
        ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator((IMObject)object, this.context);
        IMPrinterFactory factory = ServiceHelper.getBean(IMPrinterFactory.class);
        IMPrinter<T> printer = factory.create(object, locator, this.context);
        HelpContext help = this.createPrintTopic((IMObject)object);
        InteractiveIMPrinter<T> interactive = new InteractiveIMPrinter<T>(printer, this.context, help);
        interactive.setMailContext(this.getMailContext());
        return interactive;
    }

    protected void onPreview() {
        this.run(this::preview, this.getObject(), true, "preview.title");
    }

    protected void preview(T object) {
        ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator((IMObject)object, this.context);
        IMPrinterFactory factory = ServiceHelper.getBean(IMPrinterFactory.class);
        IMPrinter<T> printer = factory.create(object, locator, this.context);
        this.preview(printer);
    }

    protected void preview(Printer printer) {
        DocumentJobManager manager = ServiceHelper.getBean(DocumentJobManager.class);
        manager.preview(printer, this.getContext().getUser());
    }

    protected void onRefresh(IMObjectEditor editor) {
        this.onRefresh(editor.getObject());
        this.setSelectionPath(editor.getSelectionPath());
    }

    protected void onRefresh(T object) {
        this.setObject(null);
        if (this.listener != null) {
            this.listener.refresh(object);
        }
    }

    protected LayoutContext createLayoutContext(HelpContext help) {
        return new DefaultLayoutContext(true, (Context)new ProtectedLocationContext(this.getContext()), help);
    }

    protected void print(T object) {
        IMPrinter<T> printer = this.createPrinter(object);
        printer.print();
    }

    protected void mail(T object) {
        IMPrinter<T> printer = this.createPrinter(object);
        this.mail(printer);
    }

    protected <X> void mail(IMPrinter<X> printer) {
        Job<Document> job = JobBuilder.newJob(printer.getDisplayName(), this.getContext().getUser()).get(() -> printer.getDocument("application/pdf", true)).completed(document -> this.mail(printer.getDisplayName(), (Document)document, printer.getReporter())).build();
        DocumentJobManager manager = ServiceHelper.getBean(DocumentJobManager.class);
        manager.runInteractive(job, Messages.get((String)"document.mail.title"), Messages.get((String)"document.mail.cancel"));
    }

    protected <X> void mail(String subject, Document document, Reporter<X> reporter) {
        EmailTemplate emailTemplate;
        MailDialogFactory factory = ServiceHelper.getBean(MailDialogFactory.class);
        MailContext mailContext = this.getMailContext();
        if (mailContext == null) {
            mailContext = new UserMailContext(this.getContext());
        }
        MailDialog dialog = factory.create(mailContext, this.createLayoutContext(this.getHelpContext()));
        MailEditor editor = dialog.getMailEditor();
        editor.setSubject(subject);
        editor.addAttachment(document);
        editor.setObject(reporter.getObject());
        DocumentTemplate template = reporter.getTemplate();
        if (template != null && (emailTemplate = template.getEmailTemplate()) != null) {
            editor.setContent(emailTemplate);
        }
        dialog.show();
    }

    protected void updateContext(String shortName, T object) {
        if (TypeHelper.isA(object, (String)shortName)) {
            this.context.setObject(shortName, (IMObject)object);
        } else {
            this.context.setObject(shortName, null);
        }
    }

    protected Runnable action(String archetype, Consumer<T> action, String title) {
        return this.action(new String[]{archetype}, action, title);
    }

    protected Runnable action(String[] archetypes, Consumer<T> action, String title) {
        return this.action(archetypes, action, true, title);
    }

    protected Runnable action(String archetype, Consumer<T> action, boolean required, String title) {
        return this.action(new String[]{archetype}, action, required, title);
    }

    protected Runnable action(String[] archetypes, Consumer<T> action, boolean required, String title) {
        return this.action(archetypes, action, null, required, title);
    }

    protected Runnable action(String archetype, Consumer<T> action, Predicate<T> condition, String title) {
        return this.action(new String[]{archetype}, action, condition, title);
    }

    protected Runnable action(String[] archetypes, Consumer<T> action, Predicate<T> condition, String title) {
        return this.action(archetypes, action, condition, true, title);
    }

    protected Runnable action(String[] archetypes, Consumer<T> action, Predicate<T> condition, boolean required, String title) {
        return () -> {
            T object = this.getObject();
            if (TypeHelper.isA(object, (String[])archetypes)) {
                this.run(action, condition, object, required, title);
            }
        };
    }

    protected Runnable action(Consumer<T> action) {
        return this.action(action, true, null);
    }

    protected Runnable action(Consumer<T> action, String title) {
        return this.action(action, true, title);
    }

    protected Runnable action(Consumer<T> action, boolean required, String title) {
        return this.action(action, null, required, title);
    }

    protected Runnable action(Consumer<T> action, Predicate<T> condition) {
        return this.action(action, condition, true, null);
    }

    protected Runnable action(Consumer<T> action, Predicate<T> condition, boolean required, String title) {
        return () -> {
            T object = this.getObject();
            this.run(action, condition, object, required, title);
        };
    }

    protected IMObjectBean getBean(IMObject object) {
        return this.getService().getBean(object);
    }

    protected String getDisplayName(IMObject object) {
        return DescriptorHelper.getDisplayName((IMObject)object, (ArchetypeService)this.getService());
    }

    protected String getDisplayName(IMObject object, String node) {
        return DescriptorHelper.getDisplayName((IMObject)object, (String)node, (ArchetypeService)this.getService());
    }

    protected String getDisplayName(String archetype) {
        return DescriptorHelper.getDisplayName((String)archetype, (ArchetypeService)this.getService());
    }

    private void run(Consumer<T> action, T object, String title) {
        this.run(action, object, true, title);
    }

    private void run(Consumer<T> action, T object, boolean required, String title) {
        this.run(action, null, object, required, title);
    }

    private void run(Consumer<T> action, Predicate<T> condition, T object, boolean required, String titleKey) {
        try {
            T latest = IMObjectHelper.reload(object);
            if (latest != null || !required) {
                if (condition != null) {
                    if (condition.test(latest)) {
                        action.accept(latest);
                    } else {
                        this.onRefresh(object);
                    }
                } else {
                    action.accept(latest);
                }
            } else {
                String displayName = object != null ? this.getDisplayName((IMObject)object) : this.getArchetypes().getDisplayName();
                String title = titleKey != null ? Messages.get((String)titleKey) : null;
                ErrorHelper.show(title, Messages.format((String)"imobject.noexist", (Object[])new Object[]{displayName}));
                if (object != null) {
                    this.onRefresh(object);
                }
            }
        }
        catch (Throwable exception) {
            String title;
            String string = title = titleKey != null ? Messages.get((String)titleKey) : null;
            if (object != null) {
                String displayName = this.getDisplayName((IMObject)object);
                ErrorHelper.show(title, displayName, object, exception);
            }
            ErrorHelper.show(title, exception);
        }
    }
}

