/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workflow;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workflow.AbstractTask;
import org.openvpms.web.component.workflow.DefaultTaskContext;
import org.openvpms.web.component.workflow.DefaultTaskListener;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.TaskEvent;
import org.openvpms.web.component.workflow.TaskListener;
import org.openvpms.web.component.workflow.Workflow;
import org.openvpms.web.echo.help.HelpContext;

public class WorkflowImpl
extends AbstractTask
implements Workflow {
    private final List<Task> tasks = new ArrayList<Task>();
    private final Context parent;
    private final HelpContext help;
    private final TaskListener taskListener;
    private TaskContext initial;
    private int taskIndex;
    private boolean cancel;
    private boolean breakOnCancel = true;
    private boolean breakOnSkip;
    private Task current;

    public WorkflowImpl(HelpContext help) {
        this(null, help);
    }

    public WorkflowImpl(Context context, HelpContext help) {
        this.parent = context;
        this.help = help;
        this.taskListener = new DefaultTaskListener(){

            @Override
            public void taskEvent(TaskEvent event) {
                WorkflowImpl.this.onEvent(event);
            }
        };
    }

    @Override
    public void addTask(Task task) {
        this.tasks.add(task);
    }

    public void setBreakOnCancel(boolean breakOnCancel) {
        this.breakOnCancel = breakOnCancel;
    }

    public void setBreakOnSkip(boolean breakOnSkip) {
        this.breakOnSkip = breakOnSkip;
    }

    @Override
    public void start() {
        this.start(new DefaultTaskContext(this.parent, this.help));
    }

    @Override
    public void start(TaskContext context) {
        this.cancel = false;
        this.taskIndex = 0;
        this.initial = context;
        this.next();
    }

    public void cancel() {
        this.cancel = true;
    }

    public Task getCurrent() {
        return this.current;
    }

    public TaskContext getContext() {
        return this.initial;
    }

    protected void next() {
        if (this.cancel) {
            this.current = null;
            this.notifyCancelled();
        } else if (this.taskIndex < this.tasks.size()) {
            this.current = this.tasks.get(this.taskIndex++);
            try {
                this.current.addTaskListener(this.taskListener);
                this.start(this.current, this.initial);
            }
            catch (Throwable throwable) {
                this.taskFailed(throwable);
            }
        } else {
            this.current = null;
            this.notifyCompleted();
        }
    }

    protected void onEvent(TaskEvent event) {
        switch (event.getType()) {
            case SKIPPED: {
                if (event.getTask().isRequired()) {
                    ErrorHelper.show("Required task skipped");
                    this.cancel = true;
                    this.notifyCancelled();
                    break;
                }
                if (this.breakOnSkip) {
                    this.notifySkipped();
                    break;
                }
                this.next();
                break;
            }
            case CANCELLED: {
                if (this.breakOnCancel) {
                    this.notifyCancelled();
                    break;
                }
                this.next();
                break;
            }
            case COMPLETED: {
                this.next();
            }
        }
    }

    protected HelpContext getHelpContext() {
        return this.help;
    }

    private void taskFailed(Throwable throwable) {
        ErrorHelper.show(throwable, () -> {
            if (!this.current.isFinished()) {
                this.notifyEvent(TaskEvent.Type.CANCELLED, this.current);
            }
            this.onEvent(new TaskEvent(TaskEvent.Type.CANCELLED, this.current));
        });
    }
}

