/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workflow;

import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.print.InteractiveIMPrinter;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.print.PrinterListener;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workflow.AbstractTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class PrintIMObjectTask
extends AbstractTask {
    private final MailContext mailContext;
    private final PrintMode printMode;
    private IMObject object;
    private String shortName;
    private boolean enableSkip = true;

    public PrintIMObjectTask(IMObject object, MailContext context, PrintMode printMode) {
        this.object = object;
        this.mailContext = context;
        this.printMode = printMode;
    }

    public PrintIMObjectTask(String shortName, MailContext context) {
        this(shortName, context, true);
    }

    public PrintIMObjectTask(String shortName, MailContext context, boolean interactive) {
        this(shortName, context, interactive ? PrintMode.INTERACTIVE : PrintMode.BACKGROUND);
    }

    public PrintIMObjectTask(String shortName, MailContext context, PrintMode printMode) {
        this.shortName = shortName;
        this.mailContext = context;
        this.printMode = printMode;
    }

    public void setEnableSkip(boolean skip) {
        this.enableSkip = skip;
    }

    @Override
    public void start(TaskContext context) {
        IMObject object = this.getObject(context);
        if (object == null) {
            this.notifyCancelled();
        } else {
            this.print(object, context);
        }
    }

    protected void print(final IMObject object, final TaskContext context) {
        try {
            ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator(object, (Context)context);
            IMPrinterFactory factory = ServiceHelper.getBean(IMPrinterFactory.class);
            final IMPrinter<IMObject> printer = factory.create(object, locator, context);
            boolean skip = !this.isRequired() && this.enableSkip;
            HelpContext help = context.getHelpContext().topic(object, "print");
            InteractiveIMPrinter<IMObject> iPrinter = this.createPrinter(printer, skip, context, help);
            if (this.printMode == PrintMode.INTERACTIVE) {
                iPrinter.setInteractive(true);
            } else if (this.printMode == PrintMode.BACKGROUND) {
                iPrinter.setInteractive(false);
            }
            iPrinter.setMailContext(this.mailContext);
            iPrinter.setListener(new PrinterListener(){

                @Override
                public void printed(DocumentPrinter printer2) {
                    PrintIMObjectTask.this.onPrinted(object, context);
                }

                @Override
                public void cancelled() {
                    PrintIMObjectTask.this.notifyPrintCancelled();
                }

                @Override
                public void skipped() {
                    PrintIMObjectTask.this.notifySkipped();
                }

                @Override
                public void failed(Throwable cause) {
                    PrintIMObjectTask.this.printFailed(cause, printer);
                }
            });
            iPrinter.print();
        }
        catch (OpenVPMSException exception) {
            this.notifyCancelledOnError(exception);
        }
    }

    protected void printFailed(Throwable cause, IMPrinter<IMObject> printer) {
        if (!printer.getInteractive()) {
            this.notifyPrintCancelledOnError(cause);
        } else {
            String title = Messages.format((String)"imobject.print.title", (Object[])new Object[]{printer.getDisplayName()});
            ErrorHelper.show(title, cause);
        }
    }

    protected void notifyPrintCancelled() {
        this.notifyCancelled();
    }

    protected void notifyPrintCancelledOnError(Throwable cause) {
        this.notifyCancelledOnError(cause);
    }

    protected InteractiveIMPrinter<IMObject> createPrinter(IMPrinter<IMObject> printer, boolean skip, TaskContext context, HelpContext help) {
        return new InteractiveIMPrinter<IMObject>(printer, skip, (Context)context, help);
    }

    protected IMObject getObject(TaskContext context) {
        if (this.object == null) {
            this.object = context.getObject(this.shortName);
        }
        return this.object;
    }

    protected void onPrinted(IMObject object, TaskContext context) {
        this.notifyCompleted();
    }

    public static enum PrintMode {
        INTERACTIVE,
        BACKGROUND,
        DEFAULT;

    }
}

