/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workflow;

import java.util.Objects;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.workflow.NodeEvalTask;
import org.openvpms.web.component.workflow.TaskContext;

public class NodeConditionTask<T>
extends NodeEvalTask<Boolean> {
    private final T expected;
    private final boolean equals;

    public NodeConditionTask(String shortName, String node, T value) {
        this(shortName, node, true, value);
    }

    public NodeConditionTask(String shortName, String node, boolean equals, T value) {
        super(shortName, node);
        this.equals = equals;
        this.expected = value;
    }

    @Override
    public void start(TaskContext context) {
        IMObject object = this.getObject(context);
        if (object == null) {
            this.notifyCancelled();
        } else {
            Object value = this.getValue(object);
            boolean result = this.expected instanceof Comparable && value != null ? ((Comparable)this.expected).compareTo(value) == 0 : Objects.equals(this.expected, value);
            if (this.equals) {
                this.setValue(result);
            } else {
                this.setValue(!result);
            }
        }
    }
}

