/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workflow;

import org.openvpms.web.component.workflow.AbstractTask;
import org.openvpms.web.component.workflow.DefaultTaskListener;
import org.openvpms.web.component.workflow.EvalTask;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.TaskEvent;

public class ConditionalTask
extends AbstractTask {
    private final EvalTask<Boolean> condition;
    private final Task task;
    private final Task elseTask;
    private TaskContext context;

    public ConditionalTask(EvalTask<Boolean> condition, Task task) {
        this(condition, task, null);
    }

    public ConditionalTask(EvalTask<Boolean> condition, Task task, Task elseTask) {
        this.condition = condition;
        this.task = task;
        this.elseTask = elseTask;
        this.setRequired(condition.isRequired());
    }

    @Override
    public void start(TaskContext context) {
        this.context = context;
        this.condition.addTaskListener(new DefaultTaskListener(){

            @Override
            public void taskEvent(TaskEvent event) {
                ConditionalTask.this.onConditionEvent(event);
            }
        });
        this.task.addTaskListener(new DefaultTaskListener(){

            @Override
            public void taskEvent(TaskEvent event) {
                ConditionalTask.this.onTaskEvent(event);
            }
        });
        if (this.elseTask != null) {
            this.elseTask.addTaskListener(new DefaultTaskListener(){

                @Override
                public void taskEvent(TaskEvent event) {
                    ConditionalTask.this.onTaskEvent(event);
                }
            });
        }
        this.start(this.condition, context);
    }

    private void onConditionEvent(TaskEvent event) {
        switch (event.getType()) {
            case SKIPPED: {
                this.notifySkipped();
                break;
            }
            case CANCELLED: {
                this.notifyCancelled();
                break;
            }
            case COMPLETED: {
                if (this.condition.getValue().booleanValue()) {
                    this.start(this.task, this.context);
                    break;
                }
                if (this.elseTask != null) {
                    this.start(this.elseTask, this.context);
                    break;
                }
                this.notifyCompleted();
            }
        }
    }

    private void onTaskEvent(TaskEvent event) {
        switch (event.getType()) {
            case SKIPPED: {
                this.notifySkipped();
                break;
            }
            case CANCELLED: {
                this.notifyCancelled();
                break;
            }
            case COMPLETED: {
                this.notifyCompleted();
            }
        }
    }
}

