/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.service.archetype.ValidationError;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class ValidatorError {
    public static final String NODE_KEY = ValidatorError.class.getName() + ".node.formatted";
    public static final String PROP_KEY = ValidatorError.class.getName() + ".prop.formatted";
    public static final String MSG_KEY = ValidatorError.class.getName() + ".msg.formatted";
    private String archetype;
    private String property;
    private String displayName;
    private String message;

    public ValidatorError(ValidationError error) {
        this(error.getArchetype(), error.getNode(), error.getMessage());
    }

    public ValidatorError(String archetype, String node, String message) {
        this.archetype = archetype;
        this.property = node;
        this.message = message;
    }

    public ValidatorError(Property property, String message) {
        this.property = property.getName();
        this.displayName = property.getDisplayName();
        this.message = message;
    }

    public ValidatorError(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        if (this.archetype != null) {
            return ValidatorError.format(this.archetype, this.property, this.message);
        }
        if (this.property != null) {
            String name = this.displayName != null ? this.displayName : this.property;
            return ValidatorError.format(name, this.message);
        }
        return this.formatMessage();
    }

    public static String format(String shortName, String node, String message) {
        String archetypeName = null;
        String nodeName = null;
        ArchetypeDescriptor archetype = ServiceHelper.getArchetypeService().getArchetypeDescriptor(shortName);
        if (archetype != null) {
            archetypeName = archetype.getDisplayName();
            NodeDescriptor descriptor = archetype.getNodeDescriptor(node);
            if (descriptor != null) {
                nodeName = descriptor.getDisplayName();
            }
        }
        return Messages.format((String)NODE_KEY, (Object[])new Object[]{archetypeName, nodeName, message});
    }

    public static String format(String property, String message) {
        return Messages.format((String)PROP_KEY, (Object[])new Object[]{property, message});
    }

    private String formatMessage() {
        return Messages.format((String)MSG_KEY, (Object[])new Object[]{this.message});
    }
}

