/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.web.component.property.AbstractDateTimePropertyTransformer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyException;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;

public class TimePropertyTransformer
extends AbstractDateTimePropertyTransformer {
    public static final Date MIN_DATE;
    public static final Date MAX_DATE;
    private Date date;
    private final boolean exclusive;

    public TimePropertyTransformer(Property property) {
        this(property, null, null);
    }

    public TimePropertyTransformer(Property property, Date min, Date max) {
        this(property, min, max, true);
    }

    public TimePropertyTransformer(Property property, Date min, Date max, boolean exclusive) {
        super(property, min, max, AbstractDateTimePropertyTransformer.Format.DATE_TIME);
        this.exclusive = exclusive;
    }

    public void setDate(Date date) {
        this.date = date != null ? DateRules.getDate((Date)date) : null;
    }

    @Override
    protected Date getDateTime(Date value) {
        Date result = this.date != null ? DateRules.addDateTime((Date)this.date, (Date)value) : value;
        return result;
    }

    @Override
    protected Date getDateTime(String value) throws ParseException {
        return this.addTime(value);
    }

    @Override
    protected Date getDate() {
        return this.date;
    }

    @Override
    protected Date parseTime(String value) throws ParseException {
        return DateFormatter.parseTime((String)value, (boolean)true);
    }

    @Override
    protected void checkDateRange(Date date, Date min, Date max) {
        if (min != null && date.getTime() < min.getTime()) {
            String formatDate = DateFormatter.formatTimeDiff((Date)MIN_DATE, (Date)date);
            String formatMin = DateFormatter.formatTimeDiff((Date)MIN_DATE, (Date)min);
            String msg = Messages.format((String)"property.error.minTime", (Object[])new Object[]{formatDate, formatMin});
            throw new PropertyException(this.getProperty(), msg);
        }
        if (max != null) {
            if (this.exclusive && date.getTime() >= max.getTime()) {
                throw new PropertyException(this.getProperty(), this.formatMaxError("<", max));
            }
            if (!this.exclusive && date.getTime() > max.getTime()) {
                throw new PropertyException(this.getProperty(), this.formatMaxError("<=", max));
            }
        }
    }

    private String formatMaxError(String operator, Date max) {
        String formatMax = DateFormatter.formatTimeDiff((Date)MIN_DATE, (Date)max);
        return Messages.format((String)"property.error.maxTime", (Object[])new Object[]{this.getProperty().getDisplayName(), operator, formatMax});
    }

    static {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.clear();
        MIN_DATE = calendar.getTime();
        MAX_DATE = DateRules.getDate((Date)MIN_DATE, (int)1, (DateUnits)DateUnits.DAYS);
    }
}

