/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.macro.Macros;
import org.openvpms.macro.Position;
import org.openvpms.web.component.property.AbstractPropertyTransformer;
import org.openvpms.web.component.property.IMObjectProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyException;
import org.openvpms.web.echo.text.TextHelper;
import org.openvpms.web.resource.i18n.Messages;

public class StringPropertyTransformer
extends AbstractPropertyTransformer {
    private final Macros macros;
    private final Variables variables;
    private boolean trim;
    private final Object context;
    private boolean expandMacros;

    public StringPropertyTransformer(Property property) {
        this(property, true);
    }

    public StringPropertyTransformer(Property property, Macros macros) {
        this(property, true, macros, StringPropertyTransformer.getContext(property), null);
    }

    public StringPropertyTransformer(Property property, boolean trim) {
        this(property, trim, null, null, null);
    }

    public StringPropertyTransformer(Property property, boolean trim, Macros macros, Object context, Variables variables) {
        super(property);
        this.trim = trim;
        if (!property.isReadOnly() && !property.isDerived()) {
            this.macros = macros;
            this.context = context;
            this.variables = variables;
        } else {
            this.macros = null;
            this.context = null;
            this.variables = null;
        }
        this.expandMacros = macros != null;
    }

    public void setExpandMacros(boolean expand) {
        this.expandMacros = expand;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    @Override
    public Object apply(Object object) {
        return this.apply(object, null);
    }

    public String apply(Object object, Position position) {
        Property property = this.getProperty();
        String result = null;
        if (object instanceof String) {
            String str = (String)object;
            this.checkCharacters(str);
            result = this.expandMacros && this.macros != null ? this.macros.runAll(str, this.context, this.variables, position) : str;
        } else if (object != null) {
            result = object.toString();
        }
        if (this.trim) {
            result = StringUtils.trimToNull((String)result);
        }
        int minLength = property.getMinLength();
        int maxLength = property.getMaxLength();
        if (result == null && minLength > 0 || result != null && result.length() < minLength) {
            String msg = Messages.format((String)"property.error.minLength", (Object[])new Object[]{minLength});
            throw new PropertyException(property, msg);
        }
        if (result != null && maxLength != -1 && result.length() > maxLength) {
            String msg = Messages.format((String)"property.error.maxLength", (Object[])new Object[]{maxLength});
            throw new PropertyException(property, msg);
        }
        return result;
    }

    protected void checkCharacters(String string) {
        if (TextHelper.hasControlChars((String)string)) {
            Property property = this.getProperty();
            String msg = Messages.format((String)"property.error.invalidchars", (Object[])new Object[]{property.getDisplayName()});
            throw new PropertyException(property, msg);
        }
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isSurrogate(string.charAt(i))) continue;
            String value = i + 1 < string.length() ? string.substring(i, i + 2) : string.substring(i, i + 1);
            Property property = this.getProperty();
            String msg = Messages.format((String)"property.error.unsupportedchar", (Object[])new Object[]{property.getDisplayName(), value});
            throw new PropertyException(property, msg);
        }
    }

    private static Object getContext(Property property) {
        return property instanceof IMObjectProperty ? ((IMObjectProperty)property).getObject() : null;
    }
}

