/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.util.ObjectHelper;
import org.openvpms.web.component.property.AbstractPropertySet;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;

public class PropertySetImpl
extends AbstractPropertySet {
    private final IMObject object;
    private final Map<String, Property> properties = new LinkedHashMap<String, Property>();
    private final Map<Property, Object> derived = new HashMap<Property, Object>();
    private Collection<Property> editable;

    public PropertySetImpl(IMObject object, Collection<Property> properties) {
        this.object = object;
        this.setProperties(properties.toArray(new Property[0]));
    }

    public PropertySetImpl(Collection<Property> properties) {
        this(properties.toArray(new Property[0]));
    }

    public PropertySetImpl(Property ... properties) {
        this.object = null;
        this.setProperties(properties);
    }

    @Override
    public Property get(String name) {
        return this.properties.get(name);
    }

    @Override
    public Collection<Property> getProperties() {
        return this.properties.values();
    }

    @Override
    public Collection<Property> getEditable() {
        if (this.editable == null) {
            this.editable = super.getEditable();
        }
        return this.editable;
    }

    @Override
    public void updateDerivedProperties() {
        if (this.object != null) {
            IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
            service.deriveValues(this.object);
            for (Property property : this.derived.keySet()) {
                Object now;
                Object old = this.derived.get(property);
                if (ObjectHelper.equals(old, now = property.getValue())) continue;
                this.derived.put(property, now);
                property.refresh();
            }
        }
    }

    private void setProperties(Property[] properties) {
        for (Property property : properties) {
            this.properties.put(property.getName(), property);
            if (!property.isDerived()) continue;
            this.derived.put(property, property.getValue());
        }
        if (this.object != null && !this.derived.isEmpty()) {
            ModifiableListener listener = this::updateDerivedProperties;
            for (Property property : properties) {
                property.addModifiableListener(listener);
            }
        }
    }

    private void updateDerivedProperties(Modifiable source) {
        if (source instanceof Property && !((Property)source).isDerived()) {
            this.updateDerivedProperties();
        }
    }
}

