/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.macro.Macros;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.DelegatingProperty;
import org.openvpms.web.component.property.IMObjectProperty;
import org.openvpms.web.component.property.MutableProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetImpl;
import org.openvpms.web.component.property.RequiredProperty;
import org.openvpms.web.component.property.StringPropertyTransformer;
import org.openvpms.web.system.ServiceHelper;

public class PropertySetBuilder {
    private final IMObject object;
    private final Map<String, Property> properties = new LinkedHashMap<String, Property>();

    public PropertySetBuilder(IMObject object) {
        this(object, null);
    }

    public PropertySetBuilder(IMObject object, LayoutContext context) {
        this(object, PropertySetBuilder.getArchetypeDescriptor(object, context), context != null ? context.getVariables() : null);
    }

    public PropertySetBuilder(IMObject object, ArchetypeDescriptor archetype, Variables variables) {
        this(object, archetype, variables, ServiceHelper.getMacros());
    }

    public PropertySetBuilder(IMObject object, ArchetypeDescriptor archetype, Variables variables, Macros macros) {
        this.object = object;
        if (archetype == null) {
            throw new IllegalStateException("No archetype descriptor for object, id=" + object.getId() + ", archetype=" + object.getArchetype());
        }
        for (NodeDescriptor descriptor : archetype.getAllNodeDescriptors()) {
            IMObjectProperty property = new IMObjectProperty(object, (org.openvpms.component.model.archetype.NodeDescriptor)descriptor);
            if (property.isString() && !property.isDerived() && !property.isReadOnly()) {
                property.setTransformer(new StringPropertyTransformer(property, true, macros, object, variables));
            }
            this.properties.put(descriptor.getName(), property);
        }
    }

    public PropertySetBuilder setRequired(String name) {
        Property property = this.getProperty(name);
        this.properties.put(name, new RequiredProperty(property));
        return this;
    }

    public PropertySetBuilder setReadOnly(String name) {
        return this.setReadOnly(name, true);
    }

    public PropertySetBuilder setReadOnly(String name, final boolean readOnly) {
        Property property = this.getProperty(name);
        this.properties.put(name, new DelegatingProperty(property){

            @Override
            public boolean isReadOnly() {
                return readOnly;
            }
        });
        return this;
    }

    public PropertySetBuilder setHidden(String name) {
        return this.setHidden(name, true);
    }

    public PropertySetBuilder setHidden(String name, final boolean hidden) {
        Property property = this.getProperty(name);
        this.properties.put(name, new DelegatingProperty(property){

            @Override
            public boolean isHidden() {
                return hidden;
            }
        });
        return this;
    }

    public PropertySetBuilder setEditable(String name) {
        Property property = this.getProperty(name);
        this.properties.put(name, new DelegatingProperty(property){

            @Override
            public boolean isReadOnly() {
                return false;
            }

            @Override
            public boolean isHidden() {
                return false;
            }
        });
        return this;
    }

    public PropertySetBuilder mutable(String name) {
        Property property = this.getProperty(name);
        if (!(property instanceof MutableProperty)) {
            this.properties.put(name, new MutableProperty(property));
        }
        return this;
    }

    public PropertySetBuilder removeArchetypesFromRange(String name, String ... archetypes) {
        Property property = this.getProperty(name);
        this.properties.put(name, new RestrictedArchetypeProperty(property, archetypes));
        return this;
    }

    public PropertySet build() {
        return new PropertySetImpl(this.object, this.properties.values());
    }

    protected Property getProperty(String name) {
        Property property = this.properties.get(name);
        if (property == null) {
            throw new IllegalArgumentException("Argument 'name' doesnt refer to a valid property: " + name);
        }
        return property;
    }

    private static ArchetypeDescriptor getArchetypeDescriptor(IMObject object, LayoutContext context) {
        return context != null ? context.getArchetypeDescriptor(object) : DescriptorHelper.getArchetypeDescriptor((IMObject)object, (ArchetypeService)ServiceHelper.getArchetypeService());
    }

    private static class RestrictedArchetypeProperty
    extends DelegatingProperty {
        private final List<String> archetypesToRemove;

        public RestrictedArchetypeProperty(Property property, String[] archetypesToRemove) {
            super(property);
            this.archetypesToRemove = Arrays.asList(archetypesToRemove);
        }

        @Override
        public String[] getArchetypeRange() {
            String[] archetypeRange = super.getArchetypeRange();
            ArrayList<String> result = new ArrayList<String>(Arrays.asList(archetypeRange));
            return result.removeAll(this.archetypesToRemove) ? result.toArray(new String[0]) : archetypeRange;
        }
    }
}

