/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.util.List;
import org.openvpms.web.component.property.AbstractValidator;
import org.openvpms.web.component.property.ErrorListener;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ValidatorError;

public class NotifyingValidator
extends AbstractValidator {
    private final ErrorListener fallback;

    public NotifyingValidator(ErrorListener fallback) {
        this.fallback = fallback;
    }

    @Override
    public boolean validate(Modifiable modifiable) {
        ErrorListener listener = modifiable.getErrorListener();
        if (listener != null) {
            listener.clear();
        }
        return super.validate(modifiable);
    }

    @Override
    public void add(Modifiable modifiable, List<ValidatorError> errors) {
        super.add(modifiable, errors);
        if (!errors.isEmpty()) {
            ErrorListener listener = modifiable.getErrorListener();
            if (listener == null) {
                listener = this.fallback;
            }
            for (ValidatorError error : errors) {
                listener.error(modifiable, error);
            }
        }
    }
}

