/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeList;
import org.openvpms.component.business.domain.im.archetype.descriptor.DescriptorException;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.ValidationException;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.archetype.ArchetypeRange;
import org.openvpms.component.model.archetype.AssertionDescriptor;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.archetype.ValidationError;
import org.openvpms.web.component.im.util.ObjectHelper;
import org.openvpms.web.component.property.AbstractProperty;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.PropertyException;
import org.openvpms.web.component.property.PropertyTransformer;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMObjectProperty
extends AbstractProperty
implements CollectionProperty {
    private final IMObject object;
    private final NodeDescriptor descriptor;
    private List<ValidatorError> validationErrors;
    private static final Logger log = LoggerFactory.getLogger(IMObjectProperty.class);

    public IMObjectProperty(org.openvpms.component.model.object.IMObject object, org.openvpms.component.model.archetype.NodeDescriptor descriptor) {
        this.object = (IMObject)object;
        this.descriptor = (NodeDescriptor)descriptor;
    }

    public org.openvpms.component.model.object.IMObject getParent() {
        return this.object;
    }

    @Override
    public org.openvpms.component.model.archetype.NodeDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Object getValue() {
        return this.descriptor.getValue((org.openvpms.component.model.object.IMObject)this.object);
    }

    @Override
    public boolean setValue(Object value) {
        boolean set = false;
        this.checkModifiable();
        try {
            value = this.getTransformer().apply(value);
            if (!ObjectHelper.equals(this.getValue(), value)) {
                this.descriptor.setValue((org.openvpms.component.model.object.IMObject)this.object, value);
                set = true;
                this.refresh();
            } else if (this.validationErrors != null) {
                this.refresh();
            }
        }
        catch (DescriptorException exception) {
            this.invalidate(exception);
        }
        catch (ValidationException exception) {
            this.invalidate(exception);
        }
        catch (PropertyException exception) {
            this.invalidate(exception);
        }
        return set;
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public String getDisplayName() {
        return this.descriptor.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.descriptor.getDescription();
    }

    @Override
    public int getMinLength() {
        return this.descriptor.getMinLength();
    }

    @Override
    public int getMaxLength() {
        return this.descriptor.getMaxLength();
    }

    @Override
    public Class<?> getType() {
        return this.descriptor.getClassType();
    }

    @Override
    public boolean isBoolean() {
        return this.descriptor.isBoolean();
    }

    @Override
    public boolean isString() {
        return this.descriptor.isString();
    }

    @Override
    public boolean isNumeric() {
        return this.descriptor.isNumeric();
    }

    @Override
    public boolean isDate() {
        return this.descriptor.isDate();
    }

    @Override
    public boolean isMoney() {
        return this.descriptor.isMoney();
    }

    @Override
    public boolean isObjectReference() {
        return this.descriptor.isObjectReference();
    }

    @Override
    public boolean isLookup() {
        return this.descriptor.isLookup();
    }

    @Override
    public boolean isPassword() {
        return this.descriptor.containsAssertionType("password");
    }

    @Override
    public boolean isCollection() {
        return this.descriptor.isCollection();
    }

    @Override
    public String[] getArchetypeRange() {
        return this.getArchetypes().getArchetypes().toArray(new String[0]);
    }

    @Override
    public ArchetypeRange getArchetypes() {
        return ArchetypeList.expand((ArchetypeRange)this.descriptor.getArchetypes(), (ArchetypeService)ServiceHelper.getArchetypeService());
    }

    @Override
    public boolean isDerived() {
        return this.descriptor.isDerived();
    }

    @Override
    public boolean isReadOnly() {
        return this.descriptor.isReadOnly();
    }

    @Override
    public boolean isHidden() {
        return this.descriptor.isHidden();
    }

    @Override
    public boolean isRequired() {
        return this.descriptor.isRequired();
    }

    @Override
    public List<?> getValues() {
        List values = null;
        try {
            values = this.descriptor.getChildren((org.openvpms.component.model.object.IMObject)this.object);
            if (values != null) {
                values = Collections.unmodifiableList(values);
            }
        }
        catch (OpenVPMSException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
        return values;
    }

    @Override
    public int size() {
        List<?> values = this.getValues();
        return values != null ? values.size() : 0;
    }

    @Override
    public void add(Object value) {
        this.checkModifiable();
        try {
            value = this.getTransformer().apply(value);
            this.descriptor.addChildToCollection(this.object, value);
            this.refresh();
        }
        catch (ValidationException exception) {
            this.invalidate(exception);
        }
        catch (DescriptorException exception) {
            this.invalidate(exception);
        }
        catch (PropertyException exception) {
            this.invalidate(exception);
        }
    }

    @Override
    public boolean remove(Object value) {
        boolean result = false;
        this.checkModifiable();
        try {
            int size = this.size();
            value = this.getTransformer().apply(value);
            this.descriptor.removeChildFromCollection(this.object, value);
            if (size != this.size()) {
                result = true;
                this.refresh();
            }
        }
        catch (ValidationException exception) {
            this.invalidate(exception);
        }
        catch (DescriptorException exception) {
            this.invalidate(exception);
        }
        catch (PropertyException exception) {
            this.invalidate(exception);
        }
        return result;
    }

    @Override
    public int getMinCardinality() {
        return this.descriptor.getMinCardinality();
    }

    @Override
    public int getMaxCardinality() {
        if (this.descriptor.getMaxCardinality() == -1) {
            return -1;
        }
        return this.descriptor.getMaxCardinality();
    }

    @Override
    public boolean isParentChild() {
        return this.descriptor.isParentChild();
    }

    public org.openvpms.component.model.object.IMObject getObject() {
        return this.object;
    }

    @Override
    protected void resetValid(boolean descendants) {
        super.resetValid(descendants);
        this.validationErrors = null;
    }

    @Override
    protected boolean doValidation(Validator validator) {
        List<ValidatorError> errors = null;
        if (this.validationErrors == null || this.isDerived()) {
            this.validationErrors = null;
            int minSize = this.getMinCardinality();
            if (minSize == 1 && this.getValue() == null) {
                this.addError("property.error.required", this.descriptor.getDisplayName());
            } else if (this.descriptor.isCollection()) {
                List<?> values = this.getValues();
                int size = values.size();
                int maxSize = this.getMaxCardinality();
                if (minSize != -1 && size < minSize) {
                    this.addError("property.error.minSize", this.descriptor.getDisplayName(), minSize);
                } else if (maxSize != -1 && size > maxSize) {
                    this.addError("property.error.maxSize", this.descriptor.getDisplayName(), maxSize);
                } else if (size != 0) {
                    Object value;
                    IArchetypeRuleService service = ServiceHelper.getArchetypeService();
                    Iterator<?> iterator = this.getValues().iterator();
                    while (iterator.hasNext() && (errors = ValidationHelper.validate((org.openvpms.component.model.object.IMObject)(value = iterator.next()), (ArchetypeService)service)) == null) {
                    }
                }
            } else if (this.validateAssertions()) {
                PropertyTransformer transformer = this.getTransformer();
                try {
                    transformer.apply(this.getValue());
                }
                catch (PropertyException exception) {
                    this.invalidate(exception);
                }
            }
        }
        if (this.validationErrors != null) {
            errors = this.validationErrors;
        }
        if (errors != null) {
            validator.add((Modifiable)this, errors);
        }
        return errors == null;
    }

    private boolean validateAssertions() {
        boolean result = true;
        Collection assertions = this.descriptor.getAssertionDescriptors().values();
        Object value = this.getValue();
        if (value != null && !assertions.isEmpty()) {
            for (AssertionDescriptor assertion : assertions) {
                try {
                    if (assertion.validate(value, (org.openvpms.component.model.object.IMObject)this.object, (org.openvpms.component.model.archetype.NodeDescriptor)this.descriptor)) continue;
                    String message = assertion.getErrorMessage();
                    if (message == null) {
                        message = "Validation failed for assertion " + assertion.getName();
                    }
                    this.addError(message);
                    result = false;
                }
                catch (Exception exception) {
                    log.error("Assertion " + assertion.getName() + " failed for node " + this.descriptor, (Throwable)exception);
                    this.addError(exception.getMessage());
                    result = false;
                }
                break;
            }
        }
        return result;
    }

    private void invalidate(DescriptorException exception) {
        log.warn(exception.getMessage(), (Throwable)exception);
        this.resetErrors();
        Throwable cause = ExceptionUtils.getRootCause((Throwable)exception);
        if (cause != null) {
            this.addError(cause.getMessage());
        } else {
            this.addError(exception.getMessage());
        }
    }

    private void invalidate(ValidationException exception) {
        this.resetErrors();
        if (!exception.getErrors().isEmpty()) {
            for (ValidationError error : exception.getErrors()) {
                this.addError(new ValidatorError(error));
            }
        } else {
            this.addError(exception.getMessage());
        }
    }

    private void invalidate(PropertyException exception) {
        this.resetErrors();
        Throwable cause = ExceptionUtils.getRootCause((Throwable)((Object)exception));
        if (cause != null) {
            this.addError(cause.getMessage());
        } else {
            this.addError(exception.getMessage());
        }
    }

    private void resetErrors() {
        if (this.validationErrors != null && !this.validationErrors.isEmpty()) {
            this.validationErrors.clear();
        }
    }

    private void addError(String message) {
        this.addError(new ValidatorError(this.object.getArchetypeId().getShortName(), this.descriptor.getName(), message));
    }

    private void addError(ValidatorError error) {
        this.resetValid();
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidatorError>();
        }
        this.validationErrors.add(error);
    }

    private void addError(String message, Object ... args) {
        message = Messages.format((String)message, (Object[])args);
        this.addError(message);
    }
}

