/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractValidator
implements Validator {
    private final boolean debug = log.isDebugEnabled();
    private final Map<Modifiable, List<ValidatorError>> errors = new HashMap<Modifiable, List<ValidatorError>>();
    private static final Logger log = LoggerFactory.getLogger(AbstractValidator.class);

    protected AbstractValidator() {
    }

    @Override
    public boolean validate(Modifiable modifiable) {
        return modifiable.validate(this);
    }

    @Override
    public void add(Modifiable modifiable, String error) {
        this.add(modifiable, new ValidatorError(error));
    }

    @Override
    public void add(Modifiable modifiable, ValidatorError error) {
        List<ValidatorError> errors = Collections.singletonList(error);
        this.add(modifiable, errors);
    }

    @Override
    public void add(Modifiable modifiable, List<ValidatorError> errors) {
        if (!errors.isEmpty()) {
            if (this.debug && this.errors.isEmpty()) {
                try {
                    log.debug(errors.get(0).toString());
                }
                catch (Throwable exception) {
                    log.debug("Failed to format validation error: " + exception.getMessage(), exception);
                }
            }
            this.errors.put(modifiable, errors);
        }
    }

    @Override
    public Collection<Modifiable> getInvalid() {
        return this.errors.keySet();
    }

    @Override
    public List<ValidatorError> getErrors(Modifiable modifiable) {
        return this.errors.get(modifiable);
    }

    @Override
    public ValidatorError getFirstError() {
        Modifiable modifiable;
        List<ValidatorError> errors;
        ValidatorError error = null;
        Collection<Modifiable> invalid = this.getInvalid();
        if (!invalid.isEmpty() && !(errors = this.getErrors(modifiable = invalid.iterator().next())).isEmpty()) {
            error = errors.get(0);
        }
        return error;
    }

    @Override
    public boolean isValid() {
        return this.errors.isEmpty();
    }
}

