/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.jxpath.util.TypeConverter;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeList;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.model.archetype.ArchetypeRange;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.archetype.Units;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.jxpath.OpenVPMSTypeConverter;
import org.openvpms.component.system.common.util.PropertySetException;
import org.openvpms.web.component.property.AbstractModifiable;
import org.openvpms.web.component.property.ErrorListener;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.ModifiableListeners;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyTransformer;
import org.openvpms.web.component.property.PropertyTransformerFactory;
import org.openvpms.web.component.property.Validator;

public abstract class AbstractProperty
extends AbstractModifiable
implements Property {
    private boolean dirty;
    private ModifiableListeners listeners;
    private ErrorListener errorListener;
    private PropertyTransformer transformer;
    private static final TypeConverter CONVERTER = new OpenVPMSTypeConverter();

    @Override
    public boolean isModified() {
        return this.dirty;
    }

    @Override
    public void clearModified() {
        this.dirty = false;
    }

    @Override
    public boolean getBoolean() {
        return this.getBoolean(false);
    }

    @Override
    public boolean getBoolean(boolean defaultValue) {
        return (Boolean)this.get(defaultValue, Boolean.TYPE);
    }

    @Override
    public int getInt() {
        return this.getInt(0);
    }

    @Override
    public int getInt(int defaultValue) {
        return (Integer)this.get(defaultValue, Integer.TYPE);
    }

    @Override
    public long getLong() {
        return this.getLong(0L);
    }

    @Override
    public long getLong(long defaultValue) {
        return (Long)this.get(defaultValue, Long.TYPE);
    }

    @Override
    public String getString() {
        return this.getString(null);
    }

    @Override
    public String getString(String defaultValue) {
        return (String)this.get(defaultValue, String.class);
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.getBigDecimal(null);
    }

    @Override
    public BigDecimal getBigDecimal(BigDecimal defaultValue) {
        return (BigDecimal)this.get(defaultValue, BigDecimal.class);
    }

    @Override
    public Money getMoney() {
        return this.getMoney(null);
    }

    @Override
    public Money getMoney(Money defaultValue) {
        return (Money)this.get(defaultValue, Money.class);
    }

    @Override
    public Date getDate() {
        return this.getDate(null);
    }

    @Override
    public Date getDate(Date defaultValue) {
        return (Date)this.get(defaultValue, Date.class);
    }

    @Override
    public Reference getReference() {
        return (Reference)this.get(null, Reference.class);
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public boolean setValue(Object value) {
        return false;
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public int getMinLength() {
        return 0;
    }

    @Override
    public int getMaxLength() {
        return 0;
    }

    @Override
    public Class<?> getType() {
        return null;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isDate() {
        return false;
    }

    @Override
    public boolean isMoney() {
        return false;
    }

    @Override
    public boolean isObjectReference() {
        return false;
    }

    @Override
    public boolean isLookup() {
        return false;
    }

    @Override
    public boolean isPassword() {
        return false;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public String[] getArchetypeRange() {
        return new String[0];
    }

    @Override
    public ArchetypeRange getArchetypes() {
        String[] archetypes = this.getArchetypeRange();
        return archetypes.length != 0 ? new ArchetypeList(archetypes) : ArchetypeList.EMPTY;
    }

    @Override
    public boolean isDerived() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        Object value = this.getValue();
        boolean result = value instanceof String ? ((String)value).length() == 0 : (value instanceof Collection ? ((Collection)value).isEmpty() : value == null);
        return result;
    }

    @Override
    public Units getUnits() {
        NodeDescriptor descriptor = this.getDescriptor();
        return descriptor != null ? descriptor.getUnits() : null;
    }

    @Override
    public NodeDescriptor getDescriptor() {
        return null;
    }

    @Override
    public void setTransformer(PropertyTransformer transformer) {
        this.transformer = transformer;
    }

    @Override
    public PropertyTransformer getTransformer() {
        if (this.transformer == null) {
            this.transformer = PropertyTransformerFactory.create(this);
        }
        return this.transformer;
    }

    @Override
    public void refresh() {
        this.dirty = true;
        this.resetValid();
        if (this.listeners != null) {
            this.listeners.notifyListeners(this);
        }
    }

    @Override
    public void addModifiableListener(ModifiableListener listener) {
        if (this.listeners == null) {
            this.listeners = new ModifiableListeners();
        }
        this.listeners.addListener(listener);
    }

    @Override
    public void addModifiableListener(ModifiableListener listener, int index) {
        if (this.listeners == null) {
            this.listeners = new ModifiableListeners();
        }
        this.listeners.addListener(listener, index);
    }

    @Override
    public void removeModifiableListener(ModifiableListener listener) {
        if (this.listeners != null) {
            this.listeners.removeListener(listener);
        }
    }

    @Override
    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    @Override
    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Property) {
            Property p = (Property)obj;
            return this.getName().equals(p.getName());
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return false;
    }

    protected void checkModifiable() {
        if (this.isDerived()) {
            throw new UnsupportedOperationException("Attempt to modify derived property: " + this.getDisplayName());
        }
    }

    protected Object get(Object defaultValue, Class<?> type) {
        Object result;
        Object value = this.getValue();
        if (value != null) {
            try {
                result = CONVERTER.convert(value, type);
            }
            catch (Throwable exception) {
                throw new PropertySetException(PropertySetException.ErrorCode.ConversionFailed, exception, new Object[]{this.getName(), value, type});
            }
        } else {
            result = defaultValue;
        }
        return result;
    }
}

