/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.processor;

import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.layout.GridLayoutData;
import org.openvpms.archetype.component.processor.BatchProcessorListener;
import org.openvpms.web.component.processor.ProgressBarProcessor;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.help.HelpContext;

public class BatchProcessorDialog
extends ModalDialog {
    private final ProgressBarProcessor<?> processor;
    private final boolean closeOnCompletion;

    public BatchProcessorDialog(String title, ProgressBarProcessor<?> processor, HelpContext help) {
        this(title, null, processor, false, help);
    }

    public BatchProcessorDialog(String title, String message, ProgressBarProcessor<?> processor, boolean closeOnCompletion, HelpContext help) {
        super(title, CANCEL, help);
        Component content;
        Grid grid = new Grid();
        grid.setWidth(new Extent(100, 2));
        grid.setHeight(new Extent(100, 2));
        if (message != null) {
            Label label = LabelFactory.text((String)message);
            content = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{label, processor.getComponent()});
        } else {
            content = processor.getComponent();
        }
        GridLayoutData data = new GridLayoutData();
        data.setAlignment(Alignment.ALIGN_CENTER);
        content.setLayoutData((LayoutData)data);
        grid.add(content);
        this.getLayout().add((Component)grid);
        this.processor = processor;
        this.closeOnCompletion = closeOnCompletion;
    }

    public void show() {
        super.show();
        if (this.closeOnCompletion) {
            this.processor.setListener(new BatchProcessorListener(){

                public void completed() {
                    BatchProcessorDialog.this.close();
                }

                public void error(Throwable exception) {
                    ErrorHelper.show(exception);
                }
            });
            super.show();
        }
        this.processor.process();
    }

    protected void doCancel() {
        this.processor.cancel();
        super.doCancel();
    }

    protected ProgressBarProcessor<?> getProcessor() {
        return this.processor;
    }
}

