/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.prefs;

import echopointng.TabbedPane;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import org.openvpms.component.business.service.archetype.helper.IMObjects;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.AbstractEditableIMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.relationship.EntityLinkCollectionTargetPropertyEditor;
import org.openvpms.web.component.im.relationship.RelationshipHelper;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.TabbedPaneFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.tabpane.ObjectTabPaneModel;
import org.openvpms.web.system.ServiceHelper;

class PreferenceGroupCollectionEditor
extends AbstractEditableIMObjectCollectionEditor {
    private final FocusGroup focus = new FocusGroup("PreferenceGroupCollection");
    private ObjectTabPaneModel<IMObjectEditor> model;
    private TabbedPane pane;

    public PreferenceGroupCollectionEditor(CollectionProperty property, Entity object, LayoutContext context) {
        super(new PreferenceGroupCollectionPropertyEditor(property, object, (IMObjects)context.getCache()), (IMObject)object, context);
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        EntityLinkCollectionTargetPropertyEditor editor = this.getCollectionPropertyEditor();
        for (String linkShortName : property.getArchetypeRange()) {
            String[] shortNames;
            if (IMObjectHelper.getObject(linkShortName, editor.getRelationships()) != null) continue;
            for (String shortName : shortNames = RelationshipHelper.getTargetShortNames((ArchetypeService)service, linkShortName)) {
                IMObject group;
                if (IMObjectHelper.getObject(shortName, editor.getObjects()) != null || (group = IMObjectCreator.create(shortName)) == null) continue;
                editor.setRelationshipShortName(linkShortName);
                editor.add(group);
            }
        }
    }

    @Override
    public IMObject create() {
        return null;
    }

    @Override
    public void refresh() {
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.focus;
    }

    public IMObjectEditor getSelected() {
        return this.pane != null ? (IMObjectEditor)this.model.getObject(this.pane.getSelectedIndex()) : null;
    }

    @Override
    protected EntityLinkCollectionTargetPropertyEditor getCollectionPropertyEditor() {
        return (EntityLinkCollectionTargetPropertyEditor)super.getCollectionPropertyEditor();
    }

    @Override
    protected Component doLayout(LayoutContext context) {
        Column container = ColumnFactory.create((String)"InsetY");
        this.model = new ObjectTabPaneModel((Component)container);
        EntityLinkCollectionTargetPropertyEditor propertyEditor = this.getCollectionPropertyEditor();
        for (IMObject object : propertyEditor.getObjects()) {
            IMObjectEditor editor = propertyEditor.getEditor(object);
            if (editor == null) {
                HelpContext help = context.getHelpContext().topic(object.getArchetype() + "/edit");
                DefaultLayoutContext subContext = new DefaultLayoutContext(context, help);
                editor = subContext.getEditorFactory().create(object, this.getObject(), subContext);
                propertyEditor.setEditor(object, editor);
            }
            this.model.addTab((Object)editor, editor.getDisplayName(), editor.getComponent());
            this.focus.add(editor.getFocusGroup());
        }
        this.pane = TabbedPaneFactory.create(this.model);
        container.add((Component)this.pane);
        return container;
    }

    private static class PreferenceGroupCollectionPropertyEditor
    extends EntityLinkCollectionTargetPropertyEditor {
        public PreferenceGroupCollectionPropertyEditor(CollectionProperty property, Entity parent, IMObjects objects) {
            super(property, parent, objects);
        }

        @Override
        protected void sequence() {
        }

        @Override
        protected void sequence(EntityLink relationship) {
        }
    }
}

