/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.prefs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.clinician.ClinicianSelectField;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.edit.SelectFieldIMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.system.ServiceHelper;

public abstract class AbstractSchedulePreferenceGroupEditor
extends AbstractIMObjectEditor {
    private final SelectFieldIMObjectReferenceEditor<Entity> viewEditor;
    private final SelectFieldIMObjectReferenceEditor<Entity> scheduleEditor;
    private final ClinicianSelectField clinicianEditor;
    private List<Entity> views;

    public AbstractSchedulePreferenceGroupEditor(IMObject object, IMObject parent, LayoutContext layoutContext) {
        super(object, parent, layoutContext);
        Property view = this.getProperty("view");
        view.addModifiableListener(new ModifiableListener(){

            @Override
            public void modified(Modifiable modifiable) {
                AbstractSchedulePreferenceGroupEditor.this.onViewChanged();
            }
        });
        this.viewEditor = new SelectFieldIMObjectReferenceEditor<Entity>(view, this.getViews(), false);
        List<Entity> schedules = this.getSchedules();
        this.scheduleEditor = new SelectFieldIMObjectReferenceEditor<Entity>(this.getProperty("schedule"), schedules, true);
        this.addEditor(this.viewEditor);
        this.addEditor(this.scheduleEditor);
        this.clinicianEditor = new ClinicianSelectField(true);
        this.clinicianEditor.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                AbstractSchedulePreferenceGroupEditor.this.onClinicianChanged();
            }
        });
        this.clinicianEditor.setSelected(this.getProperty("clinician").getReference());
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        IMObjectLayoutStrategy strategy = super.createLayoutStrategy();
        strategy.addComponent(new ComponentState(this.viewEditor));
        strategy.addComponent(new ComponentState(this.scheduleEditor));
        strategy.addComponent(new ComponentState((Component)this.clinicianEditor, this.getProperty("clinician")));
        return strategy;
    }

    protected List<Entity> getViews() {
        if (this.views == null) {
            this.views = new ArrayList<Entity>();
            UserRules rules = ServiceHelper.getBean(UserRules.class);
            Context context = this.getLayoutContext().getContext();
            User user = context.getUser();
            Party practice = context.getPractice();
            if (user != null && practice != null) {
                List locations = rules.getLocations(user, practice);
                for (Party location : locations) {
                    IMObjectBean bean = this.getBean((IMObject)location);
                    this.views.addAll(this.getViews(bean));
                }
                IMObjectSorter.sort(this.views, "name");
            }
        }
        return this.views;
    }

    protected abstract List<Entity> getViews(IMObjectBean var1);

    protected abstract List<Entity> getSchedules(Entity var1);

    protected List<Entity> getSchedules() {
        List<Entity> schedules = Collections.emptyList();
        Entity view = IMObjectHelper.getObject(this.getProperty("view").getReference(), this.getViews());
        if (view != null) {
            schedules = this.getSchedules(view);
            IMObjectSorter.sort(schedules, "name");
        }
        return schedules;
    }

    private void onViewChanged() {
        this.scheduleEditor.setObjects(this.getSchedules());
        this.scheduleEditor.setObject(null);
    }

    private void onClinicianChanged() {
        User selected = this.clinicianEditor.getSelected();
        this.getProperty("clinician").setValue(selected != null ? selected.getObjectReference() : null);
    }
}

