/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.party.Contact;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.query.DefaultIMObjectTableBrowser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.select.MultiIMObjectSelector;
import org.openvpms.web.component.im.select.SelectedObjects;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.mail.AddressFormatter;
import org.openvpms.web.component.mail.AddressSelector;
import org.openvpms.web.component.mail.EmailAddress;
import org.openvpms.web.component.mail.EmailQuery;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

class MultiContactSelector
extends MultiIMObjectSelector<org.openvpms.component.model.party.Contact> {
    private final AddressFormatter formatter;

    public MultiContactSelector(AddressFormatter formatter, LayoutContext context) {
        super(DescriptorHelper.getDisplayName((String)"contact.email", (ArchetypeService)ServiceHelper.getArchetypeService()), new Contacts(formatter), false, context, new String[0]);
        this.formatter = formatter;
    }

    @Override
    protected Query<org.openvpms.component.model.party.Contact> createQuery(String value) {
        EmailQuery query = new EmailQuery();
        query.setValue(value);
        return query;
    }

    @Override
    protected Browser<org.openvpms.component.model.party.Contact> createBrowser(final Query<org.openvpms.component.model.party.Contact> query, LayoutContext context) {
        return new DefaultIMObjectTableBrowser<org.openvpms.component.model.party.Contact>(query, context){

            @Override
            protected IMTableModel<org.openvpms.component.model.party.Contact> createTableModel(LayoutContext context) {
                return new EmailTableModel(query, MultiContactSelector.this.formatter);
            }
        };
    }

    @Override
    protected BrowserDialog<org.openvpms.component.model.party.Contact> createBrowserDialog(Browser<org.openvpms.component.model.party.Contact> browser, LayoutContext context) {
        BrowserDialog<org.openvpms.component.model.party.Contact> dialog = new BrowserDialog<org.openvpms.component.model.party.Contact>(Messages.get((String)"mail.addressbook"), browser, false, context.getHelpContext());
        dialog.setStyleName("AddressBook");
        return dialog;
    }

    @Override
    protected boolean query(String text, int index) {
        boolean result;
        String name = null;
        int less = text.indexOf(60);
        if (less != -1) {
            name = text.substring(0, less).trim();
            int greater = text.indexOf(62, less);
            if (greater != -1) {
                text = text.substring(less + 1, greater);
            }
        }
        if (text.indexOf(64) != -1) {
            EmailAddress address = new EmailAddress(text, name);
            org.openvpms.component.model.party.Contact contact = AddressSelector.createContact(address);
            this.setObject(index, contact);
            result = true;
        } else {
            result = super.query(text, index);
        }
        return result;
    }

    private static Party getParty(org.openvpms.component.model.party.Contact contact) {
        return ((Contact)contact).getParty();
    }

    private static class EmailTableModel
    extends AbstractIMTableModel<org.openvpms.component.model.party.Contact> {
        private final AddressFormatter formatter;
        private static final int NAME_INDEX = 0;
        private static final int EMAIL_INDEX = 1;
        private static final int TYPE_INDEX = 2;
        private static final int ACTIVE_INDEX = 3;

        public EmailTableModel(Query<org.openvpms.component.model.party.Contact> query, AddressFormatter formatter) {
            this.formatter = formatter;
            boolean active = query.getActive() == BaseArchetypeConstraint.State.BOTH;
            DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
            columnModel.addColumn(EmailTableModel.createTableColumn(0, "table.imobject.name"));
            columnModel.addColumn(EmailTableModel.createTableColumn(1, "mail.email"));
            columnModel.addColumn(EmailTableModel.createTableColumn(2, "mail.type"));
            if (active) {
                columnModel.addColumn(EmailTableModel.createTableColumn(3, "table.imobject.active"));
            }
            this.setTableColumnModel((TableColumnModel)columnModel);
        }

        @Override
        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            if (column == 0) {
                return new SortConstraint[]{Constraints.sort((String)"party", (String)"name", (boolean)ascending), Constraints.sort((String)"party", (String)"id")};
            }
            return null;
        }

        @Override
        protected Object getValue(org.openvpms.component.model.party.Contact object, TableColumn column, int row) {
            Object result = null;
            switch (column.getModelIndex()) {
                case 0: {
                    result = this.formatter.getQualifiedName(object);
                    if (result != null) break;
                    result = this.formatter.getAddress(object);
                    break;
                }
                case 1: {
                    result = this.formatter.getAddress(object);
                    break;
                }
                case 2: {
                    result = this.getDisplayName(object);
                    break;
                }
                case 3: {
                    Party party = MultiContactSelector.getParty(object);
                    if (party == null) break;
                    result = this.getActive((IMObject)party);
                }
            }
            return result;
        }

        private Object getDisplayName(org.openvpms.component.model.party.Contact contact) {
            Party party = MultiContactSelector.getParty(contact);
            return party != null ? this.getDisplayName((IMObject)party) : null;
        }
    }

    private static class Contacts
    extends SelectedObjects<org.openvpms.component.model.party.Contact> {
        private final AddressFormatter formatter;

        public Contacts(AddressFormatter formatter) {
            this.formatter = formatter;
        }

        @Override
        protected String getName(org.openvpms.component.model.party.Contact object) {
            return this.formatter.getNameAddress(object, false);
        }

        @Override
        protected boolean matches(String name, org.openvpms.component.model.party.Contact object, boolean ignoreCase) {
            String formatted = this.getName(object);
            return ignoreCase ? StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)formatted) : StringUtils.equals((CharSequence)name, (CharSequence)formatted);
        }
    }
}

