/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import echopointng.KeyStrokeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.layout.GridLayoutData;
import nextapp.echo2.app.layout.TableLayoutData;
import nextapp.echo2.app.table.DefaultTableModel;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.macro.Macros;
import org.openvpms.report.DocumentConverter;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.bound.BoundRichTextArea;
import org.openvpms.web.component.im.doc.DocumentViewer;
import org.openvpms.web.component.im.doc.Downloader;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.mail.AddressSelector;
import org.openvpms.web.component.mail.HtmlFilter;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.MailHeader;
import org.openvpms.web.component.mail.ParameterEmailTemplateEvaluator;
import org.openvpms.web.component.property.AbstractModifiable;
import org.openvpms.web.component.property.ErrorListener;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.ModifiableListeners;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.StringPropertyTransformer;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.factory.TableFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.table.AbstractTableCellRenderer;
import org.openvpms.web.echo.table.DefaultTableCellRenderer;
import org.openvpms.web.echo.text.MacroExpander;
import org.openvpms.web.echo.text.RichTextArea;
import org.openvpms.web.echo.util.DoubleClickMonitor;
import org.openvpms.web.echo.util.StyleSheetHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailEditor
extends AbstractModifiable {
    private final MailHeader header;
    private final Context context;
    private final HelpContext help;
    private final SimpleProperty message;
    private final MacroExpander macroExpander;
    private final ModifiableListeners listeners = new ModifiableListeners();
    private final List<DocRef> documents = new ArrayList<DocRef>();
    private final DoubleClickMonitor monitor = new DoubleClickMonitor();
    private final RichTextArea messageEditor;
    private boolean modified;
    private Table attachments;
    private FocusGroup focus;
    private SplitPane headerAttachmentsPane;
    private DefaultTableModel model;
    private SplitPane component;
    private Object object;
    private static final Logger log = LoggerFactory.getLogger(MailEditor.class);

    public MailEditor(final MailContext mailContext, Contact preferredTo, LayoutContext context) {
        this.header = this.createHeader(mailContext, preferredTo, context);
        this.context = context.getContext();
        this.help = context.getHelpContext();
        final Variables variables = mailContext.getVariables();
        final Macros macros = ServiceHelper.getMacros();
        this.message = new SimpleProperty("message", null, String.class, Messages.get((String)"mail.message"));
        this.message.setTransformer(new StringPropertyTransformer(this.message, false){

            @Override
            protected void checkCharacters(String string) {
            }
        });
        this.message.setRequired(false);
        this.message.setMaxLength(-1);
        this.message.setValue(" ");
        this.macroExpander = new MacroExpander(){

            public String expand(String macro) {
                String result = null;
                try {
                    result = macros.run(macro, mailContext.getMacroContext(), variables);
                }
                catch (Throwable exception) {
                    log.error("Failed to expand macro: " + macro, exception);
                }
                return result;
            }
        };
        this.messageEditor = this.createMessageEditor(this.message);
    }

    public void setFrom(Contact from) {
        this.header.setFrom(from);
    }

    public String getFrom() {
        return this.header.getFrom();
    }

    public void setTo(Contact toAddress) {
        this.header.setTo(toAddress);
    }

    public String[] getTo() {
        return this.header.getTo();
    }

    public String[] getCc() {
        return this.header.getCc();
    }

    public String[] getBcc() {
        return this.header.getBcc();
    }

    public void setSubject(String subject) {
        this.header.setSubject(subject);
    }

    public String getSubject() {
        return this.header.getSubject();
    }

    public String getMessage() {
        String result = null;
        String value = this.message.getString();
        if (!StringUtils.isBlank((CharSequence)value)) {
            result = "<html><body>" + value + "</body></html>";
        }
        return result;
    }

    public void setMessage(String message) {
        if (message != null) {
            message = this.filter(message);
        }
        this.message.setValue(message);
    }

    public void setContent(EmailTemplate template) {
        this.setContent(template, false);
    }

    public void setContent(EmailTemplate template, boolean prompt) {
        ParameterEmailTemplateEvaluator evaluator = new ParameterEmailTemplateEvaluator(template, this.context, this.help);
        evaluator.evaluate(this.object, prompt, (subject, message) -> {
            Contact contact;
            if (template.getDefaultEmailAddress() != null && (contact = AddressSelector.createContact(template.getDefaultEmailAddress())) != null) {
                this.header.addTo(contact);
                this.header.setTo(contact);
            }
            this.setSubject(subject);
            this.setMessage(message);
            for (DocumentTemplate form : template.getAttachments(true)) {
                Document document = form.getDocument();
                if (document == null) continue;
                this.addAttachment(document);
            }
        });
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    public void addAttachment(Document document) {
        if (this.attachments == null) {
            this.createAttachments();
        }
        boolean delete = false;
        DocumentConverter converter = ServiceHelper.getBean(DocumentConverter.class);
        if (document.getMimeType() != null && !"application/pdf".equals(document.getMimeType()) && converter.canConvert(document, "application/pdf")) {
            document = converter.convert(document, "application/pdf", true);
        }
        if (document.isNew()) {
            ServiceHelper.getArchetypeService().save((IMObject)document);
            delete = true;
        }
        DocRef ref = new DocRef(document, delete);
        this.documents.add(ref);
        DocumentViewer documentViewer = new DocumentViewer(ref.getReference(), null, ref.getName(), true, false, new DefaultLayoutContext(this.context, this.help));
        documentViewer.setNameLength(18);
        documentViewer.setDownloadListener((downloader, mimeType) -> this.onDownload(downloader, mimeType, ref.getReference()));
        Component viewer = documentViewer.getComponent();
        if (viewer instanceof Button) {
            Button button = (Button)viewer;
            button.setBorder(new Border(0, Color.WHITE, 0));
            button.setRolloverBorder(new Border(0, Color.WHITE, 0));
        }
        Label sizeLabel = this.getSizeLabel(ref.getSize());
        TableLayoutData layout = new TableLayoutData();
        layout.setAlignment(Alignment.ALIGN_RIGHT);
        sizeLabel.setLayoutData((LayoutData)layout);
        this.model.addRow(new Object[]{RowFactory.create((Component[])new Component[]{viewer}), sizeLabel});
        this.updateAttachments();
    }

    public List<Reference> getAttachments() {
        List<Reference> result;
        if (this.documents.isEmpty()) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList();
            for (DocRef doc : this.documents) {
                result.add(doc.getReference());
            }
        }
        return result;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = this.createComponent();
        }
        return this.component;
    }

    public FocusGroup getFocusGroup() {
        return this.focus;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void clearModified() {
        this.modified = false;
    }

    @Override
    public void addModifiableListener(ModifiableListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void addModifiableListener(ModifiableListener listener, int index) {
        this.listeners.addListener(listener, index);
    }

    @Override
    public void removeModifiableListener(ModifiableListener listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public void setErrorListener(ErrorListener listener) {
    }

    @Override
    public ErrorListener getErrorListener() {
        return null;
    }

    public void dispose() {
        this.component = null;
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        for (DocRef doc : this.documents) {
            if (!doc.getDelete()) continue;
            service.remove(doc.getReference());
        }
        this.documents.clear();
    }

    public MailContext getMailContext() {
        return this.header.getMailContext();
    }

    public KeyStrokeListener getKeyStrokeListener() {
        return this.messageEditor.getListener();
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return this.header.validate(validator) && validator.validate(this.message);
    }

    protected MailHeader getHeader() {
        return this.header;
    }

    protected MailHeader createHeader(MailContext mailContext, Contact preferredTo, LayoutContext context) {
        return new MailHeader(mailContext, preferredTo, context);
    }

    protected RichTextArea createMessageEditor(Property message) {
        BoundRichTextArea result = new BoundRichTextArea(message);
        result.setMacroExpander(this.macroExpander);
        result.setStyleName("MailEditor.message");
        return result;
    }

    protected SplitPane createComponent() {
        this.focus = new FocusGroup("MailEditor");
        int inset = StyleSheetHelper.getProperty((String)"padding.large", (int)1);
        GridLayoutData rightInset = new GridLayoutData();
        rightInset.setInsets(new Insets(0, 0, inset, 0));
        SplitPane component = SplitPaneFactory.create((int)5, (String)"MailEditor", (Component[])new Component[]{this.header.getComponent(), ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{this.messageEditor})});
        this.focus.add(this.header.getFocusGroup());
        this.focus.add((Component)this.messageEditor);
        this.focus.setDefault(this.header.getFocusGroup().getDefaultFocus());
        return component;
    }

    private void createAttachments() {
        this.model = new DefaultTableModel(2, 0);
        this.attachments = TableFactory.create((TableModel)this.model, (String)"MailEditor.attachments");
        this.attachments.setDefaultRenderer(Object.class, DefaultTableCellRenderer.INSTANCE);
        this.attachments.setDefaultHeaderRenderer((TableCellRenderer)new AbstractTableCellRenderer(){

            protected Component getComponent(Table table, Object value, int column, int row) {
                Component result = super.getComponent(table, value, column, row);
                if (column == 1) {
                    TableLayoutData layout = new TableLayoutData();
                    layout.setAlignment(Alignment.ALIGN_RIGHT);
                    result.setLayoutData((LayoutData)layout);
                }
                return result;
            }
        });
        this.attachments.setHeaderVisible(true);
        this.component.remove(this.header.getComponent());
        KeyStrokeListener listener = new KeyStrokeListener();
        listener.setCancelMode(true);
        listener.addKeyCombination(46);
        listener.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                int index = MailEditor.this.attachments.getSelectionModel().getMinSelectedIndex();
                if (index != -1 && index < MailEditor.this.documents.size()) {
                    MailEditor.this.deleteAttachment(index);
                }
            }
        });
        this.headerAttachmentsPane = SplitPaneFactory.create((int)1, (String)"MailEditor.grid", (Component[])new Component[]{this.header.getComponent(), ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{this.attachments, listener})});
        this.component.add((Component)this.headerAttachmentsPane, 0);
        this.updateAttachments();
    }

    private void updateAttachments() {
        long size = 0L;
        for (DocRef doc : this.documents) {
            size += doc.getSize();
        }
        this.model.setColumnName(0, Messages.format((String)"mail.attachments", (Object[])new Object[]{this.documents.size()}));
        this.model.setColumnName(1, NumberFormatter.getSize((long)size));
    }

    private void deleteAttachment(int index) {
        DocRef ref = this.documents.get(index);
        if (ref.getDelete()) {
            this.delete(ref.getReference());
        }
        this.documents.remove(index);
        this.model.deleteRow(index);
        if (this.documents.isEmpty()) {
            this.component.remove((Component)this.headerAttachmentsPane);
            this.component.add(this.header.getComponent(), 0);
            this.attachments = null;
        } else {
            this.updateAttachments();
        }
    }

    private void delete(Reference reference) {
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        service.remove(reference);
    }

    private void onDownload(Downloader downloader, String mimeType, Reference reference) {
        int hash = System.identityHashCode(downloader);
        if (this.monitor.isDoubleClick((Object)hash)) {
            downloader.download(mimeType);
        }
        for (int i = 0; i < this.documents.size(); ++i) {
            if (!this.documents.get(i).getReference().equals((Object)reference)) continue;
            this.attachments.getSelectionModel().setSelectedIndex(i, true);
            break;
        }
    }

    private Label getSizeLabel(long size) {
        String displaySize = NumberFormatter.getSize((long)size);
        Label label = LabelFactory.create();
        label.setText(displaySize);
        return label;
    }

    private String filter(String html) {
        return HtmlFilter.filter(html);
    }

    private static class DocRef {
        private final Reference ref;
        private final String name;
        private final String mimeType;
        private final long size;
        private final boolean delete;

        public DocRef(Document document, boolean delete) {
            this.ref = document.getObjectReference();
            this.name = document.getName();
            this.mimeType = document.getMimeType();
            this.size = document.getSize();
            this.delete = delete;
        }

        public String getName() {
            return this.name;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public long getSize() {
            return this.size;
        }

        public boolean getDelete() {
            return this.delete;
        }

        public Reference getReference() {
            return this.ref;
        }
    }
}

