/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Variables;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openvpms.archetype.rules.doc.BaseDocumentTemplate;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.macro.Macros;
import org.openvpms.report.DocumentConverter;
import org.openvpms.report.IMReport;
import org.openvpms.report.ReportFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.report.ReportContextFactory;
import org.openvpms.web.component.im.report.Reporter;
import org.openvpms.web.component.macro.MacroVariables;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailTemplateEvaluator {
    private final ArchetypeService service;
    private final LookupService lookups;
    private final Macros macros;
    private final ReportFactory factory;
    private final DocumentConverter converter;
    private static final Logger log = LoggerFactory.getLogger(EmailTemplateEvaluator.class);

    public EmailTemplateEvaluator(ArchetypeService service, LookupService lookups, Macros macros, ReportFactory factory, DocumentConverter converter) {
        this.service = service;
        this.lookups = lookups;
        this.macros = macros;
        this.factory = factory;
        this.converter = converter;
    }

    public String getSubject(EmailTemplate template, Object object, Context context) {
        String result = null;
        EmailTemplate.SubjectType type = template.getSubjectType();
        String subject = template.getSubject();
        String expression = template.getSubjectSource();
        switch (type) {
            case TEXT: {
                result = subject;
                break;
            }
            case MACRO: {
                result = this.evaluateMacros(subject, expression, object, context);
                break;
            }
            case XPATH: {
                result = this.evaluateXPath(subject, expression, object, context);
            }
        }
        return result;
    }

    public String getMessage(EmailTemplate template, Object object, Context context) {
        String result = null;
        EmailTemplate.ContentType type = template.getContentType();
        String content = template.getContent();
        String expression = template.getContentSource();
        switch (type) {
            case TEXT: {
                result = content;
                break;
            }
            case MACRO: {
                result = this.evaluateMacros(content, expression, object, context);
                break;
            }
            case XPATH: {
                result = this.evaluateXPath(content, expression, object, context);
                break;
            }
            case DOCUMENT: {
                result = this.evaluateDocument(template, expression, object, context);
            }
        }
        if (result != null && EmailTemplate.ContentType.DOCUMENT != type) {
            result = this.toHTML(result);
        }
        return result;
    }

    public Reporter<IMObject> getMessageReporter(EmailTemplate template, Object object, Context context) {
        String expression;
        Object contextBean;
        Reporter<IMObject> result = null;
        if (EmailTemplate.ContentType.DOCUMENT == template.getContentType() && (contextBean = this.getContextBean(expression = template.getContentSource(), object, context)) instanceof IMObject && this.factory.isIMObjectReport((BaseDocumentTemplate)template)) {
            result = this.createReporter((IMObject)contextBean, template, context);
        }
        return result;
    }

    public Reporter<ObjectSet> getMessageReporter(EmailTemplate template, List<ObjectSet> objects, Context context) {
        Reporter<ObjectSet> result = null;
        if (EmailTemplate.ContentType.DOCUMENT == template.getContentType() && this.factory.isObjectSetReport((BaseDocumentTemplate)template, objects.size())) {
            result = this.createReporter(objects, (BaseDocumentTemplate)template, context);
        }
        return result;
    }

    public String getMessage(Reporter<?> reporter) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        reporter.generate("text/html", true, bytes);
        String result = new String(bytes.toByteArray(), StandardCharsets.UTF_8);
        return result;
    }

    private Reporter<IMObject> createReporter(IMObject object, final EmailTemplate template, Context context) {
        Reporter<IMObject> result = new Reporter<IMObject>(object){

            @Override
            protected IMReport<IMObject> getReport() {
                return EmailTemplateEvaluator.this.factory.createIMObjectReport((BaseDocumentTemplate)template);
            }
        };
        result.setFields(ReportContextFactory.create(context));
        return result;
    }

    private Reporter<ObjectSet> createReporter(List<ObjectSet> objects, final BaseDocumentTemplate template, Context context) {
        Reporter<ObjectSet> result = new Reporter<ObjectSet>(objects){

            @Override
            protected IMReport<ObjectSet> getReport() {
                return EmailTemplateEvaluator.this.factory.createObjectSetReport(template);
            }
        };
        result.setFields(ReportContextFactory.create(context));
        return result;
    }

    private String evaluateMacros(String value, String expression, Object object, Context context) {
        Object contextBean = this.getContextBean(expression, object, context);
        MacroVariables variables = new MacroVariables(context, this.service, this.lookups);
        return this.macros.runAll(value, contextBean, (org.openvpms.component.system.common.util.Variables)variables, null, true);
    }

    private String evaluateXPath(String value, String expression, Object object, Context context) {
        MacroVariables variables = new MacroVariables(context, this.service, this.lookups);
        variables.declareVariable("nl", "\n");
        Object contextBean = this.getContextBean(expression, object, context);
        JXPathContext jxPathContext = JXPathHelper.newContext((Object)contextBean);
        jxPathContext.setVariables((Variables)variables);
        return (String)jxPathContext.getValue(value, String.class);
    }

    private String evaluateDocument(EmailTemplate template, String expression, Object object, Context context) {
        String result = null;
        Object contextBean = this.getContextBean(expression, object, context);
        if ("text/html".equals(template.getMimeType())) {
            Document document = template.getDocument();
            if (document != null) {
                DocumentHandlers handlers = ServiceHelper.getBean(DocumentHandlers.class);
                DocumentHandler handler = handlers.get(document);
                try {
                    int size = document.getSize();
                    if (size <= 0) {
                        size = 1024;
                    }
                    ByteArrayOutputStream stream = new ByteArrayOutputStream(size);
                    IOUtils.copy((InputStream)handler.getContent(document), (OutputStream)stream);
                    result = new String(stream.toByteArray(), StandardCharsets.UTF_8);
                }
                catch (IOException exception) {
                    log.error("Failed to get HTML document, id=" + document.getId(), (Throwable)exception);
                }
            }
        } else if (contextBean instanceof IMObject && this.factory.isIMObjectReport((BaseDocumentTemplate)template)) {
            Reporter<IMObject> reporter = this.createReporter((IMObject)contextBean, template, context);
            result = this.getMessage(reporter);
        } else {
            Document document = template.getDocument();
            if (document != null && this.converter.canConvert(document, "text/html")) {
                byte[] converted = this.converter.export(document, "text/html", true);
                result = new String(converted, StandardCharsets.UTF_8);
            }
        }
        return result;
    }

    private String toHTML(String string) {
        string = StringEscapeUtils.escapeHtml4((String)string);
        string = string.replaceAll("\n", "<br/>");
        return string;
    }

    private Object getContextBean(String expression, Object object, Context context) {
        Object result;
        if (object == null) {
            object = new Object();
        }
        if (!StringUtils.isBlank((CharSequence)expression)) {
            MacroVariables variables = new MacroVariables(context, this.service, this.lookups);
            JXPathContext xpathContext = JXPathHelper.newContext((Object)object);
            xpathContext.setVariables((Variables)variables);
            result = xpathContext.getValue(expression);
        } else {
            result = object;
        }
        return result;
    }
}

