/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.StringUtils;

public class EmailAddress {
    private final String address;
    private final String name;

    public EmailAddress(String address, String name) {
        this.address = address;
        this.name = name;
    }

    public String getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean strict) {
        String result;
        if (!StringUtils.isEmpty((CharSequence)this.name)) {
            StringBuilder builder = new StringBuilder();
            if (strict) {
                builder.append('\"');
                builder.append(this.name.replaceAll("\"", ""));
                builder.append("\" ");
            } else {
                builder.append(this.name);
                builder.append(' ');
            }
            builder.append('<');
            builder.append(this.address);
            builder.append('>');
            result = builder.toString();
        } else {
            result = this.address;
        }
        return result;
    }

    public static EmailAddress parse(String address) {
        EmailAddress result = null;
        if (address != null) {
            try {
                InternetAddress addr = new InternetAddress(address, true);
                result = new EmailAddress(addr.getAddress(), addr.getPersonal());
            }
            catch (AddressException addressException) {
                // empty catch block
            }
        }
        return result;
    }
}

