/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import java.util.List;
import org.openvpms.component.model.party.Contact;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.mail.AddressSelector;
import org.openvpms.web.component.mail.FromAddressFormatter;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;

public class EditableAddressSelector
extends AddressSelector {
    private final List<Contact> contacts;
    private final Property property;
    private final ModifiableListener propertyListener;
    private Contact selected;

    public EditableAddressSelector(Property property, List<Contact> contacts) {
        super(contacts, new FromAddressFormatter(), BoundTextComponentFactory.create(property, 40));
        this.contacts = contacts;
        this.property = property;
        this.propertyListener = modifiable -> this.updateSelectionFromProperty();
        this.updateSelectionFromProperty();
    }

    @Override
    public void setSelected(Contact contact) {
        this.setSelected(contact, true);
    }

    @Override
    public Contact getSelected() {
        return this.selected;
    }

    @Override
    public boolean isModified() {
        return super.isModified() || this.property.isModified();
    }

    @Override
    public void clearModified() {
        super.clearModified();
        this.property.clearModified();
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return this.property.validate(validator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelected(Contact contact, boolean updateProperty) {
        super.setSelected(contact);
        this.selected = contact;
        if (updateProperty) {
            this.property.removeModifiableListener(this.propertyListener);
            try {
                String address = contact != null ? this.getFormatter().getAddress(contact) : null;
                this.property.setValue(address);
            }
            finally {
                this.property.addModifiableListener(this.propertyListener);
            }
        }
    }

    private void updateSelectionFromProperty() {
        String address = this.property.getString();
        Contact contact = address != null ? AddressSelector.getContact(this.contacts, address) : null;
        this.setSelected(contact, false);
    }
}

