/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.job;

import java.util.Date;
import java.util.function.Consumer;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.job.Job;
import org.openvpms.web.component.job.JobThread;

public abstract class AbstractJob<T>
implements Job<T> {
    private final String name;
    private final User user;
    private final Date created;
    private Date started;

    public AbstractJob(String name, User user) {
        this.name = name;
        this.user = user;
        this.created = new Date();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public synchronized Date getStarted() {
        return this.started;
    }

    @Override
    public final T get() {
        this.started();
        return this.runJob();
    }

    @Override
    public Consumer<T> getCompletionListener() {
        return null;
    }

    @Override
    public Runnable getCancellationListener() {
        return null;
    }

    @Override
    public Consumer<Throwable> getFailureListener() {
        return null;
    }

    @Override
    public void cancel(JobThread thread) {
        thread.interrupt();
    }

    protected synchronized void started() {
        this.started = new Date();
    }

    protected abstract T runJob();
}

