/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.view;

import java.util.List;
import java.util.Stack;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SplitPane;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.view.IMObjectViewer;
import org.openvpms.web.component.im.view.Selection;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.help.HelpContext;

public class IMObjectViewerDialog
extends ModalDialog {
    private final Stack<Reference> history = new Stack();
    private final Context context;
    private final MailContext mailContext;
    private Component current;
    private ContextSwitchListener defaultListener;
    private ContextSwitchListener listener;
    private static final String STYLE = "IMObjectViewerDialog";
    private static final String PREVIOUS_ID = "previous";
    private static final String[] BUTTONS = new String[]{"cancel", "previous"};

    public IMObjectViewerDialog(Context context, MailContext mailContext, HelpContext help) {
        this(context, OK, mailContext, help);
    }

    public IMObjectViewerDialog(Context context, String[] buttons, MailContext mailContext, HelpContext help) {
        super(null, STYLE, buttons, help);
        this.context = context;
        this.mailContext = mailContext;
        this.setModal(true);
        this.setDefaultCloseAction("cancel");
        this.defaultListener = new ContextSwitchListener(){

            @Override
            public void switchTo(IMObject child) {
                IMObjectViewerDialog.this.changeObject(child);
            }

            @Override
            public void switchTo(String shortName) {
            }
        };
    }

    public IMObjectViewerDialog(IMObjectViewer viewer, Context context, HelpContext help) {
        this(viewer, BUTTONS, context, help);
    }

    public IMObjectViewerDialog(IMObjectViewer viewer, String[] buttons, Context context, HelpContext help) {
        this(context, buttons, null, help);
        if (viewer != null) {
            this.setViewer(viewer);
        } else {
            this.enableButtons();
        }
    }

    public IMObjectViewerDialog(IMObject object, Context context, HelpContext help) {
        this(object, BUTTONS, context, null, help);
    }

    public IMObjectViewerDialog(IMObject object, Context context, MailContext mailContext, HelpContext help) {
        this(object, BUTTONS, context, mailContext, help);
    }

    public IMObjectViewerDialog(IMObject object, String[] buttons, Context context, MailContext mailContext, HelpContext help) {
        this(context, buttons, mailContext, help);
        if (object != null) {
            this.setObject(object);
        } else {
            this.enableButtons();
        }
    }

    public void setContextSwitchListener(ContextSwitchListener listener) {
        this.listener = listener;
        if (listener == null) {
            this.defaultListener = null;
        }
    }

    public void disableHyperlinks() {
        this.setContextSwitchListener(null);
    }

    public void setObject(IMObject object) {
        this.setObject(object, null);
    }

    public void setObject(IMObject object, List<Selection> path) {
        DefaultLayoutContext context = new DefaultLayoutContext(this.context, this.getHelpContext());
        context.setMailContext(this.mailContext);
        context.setContextSwitchListener(this.defaultListener);
        IMObjectViewer viewer = new IMObjectViewer(object, null, context);
        this.setViewer(viewer);
        if (path != null) {
            viewer.setSelectionPath(path);
        }
    }

    public void setViewer(IMObjectViewer viewer) {
        this.setTitle(viewer.getTitle());
        SplitPane pane = this.getLayout();
        if (this.current != null) {
            pane.remove(this.current);
        }
        this.current = viewer.getComponent();
        pane.add(this.current);
        Reference reference = viewer.getObject().getObjectReference();
        this.history.push(reference);
        this.enableButtons();
    }

    protected void onButton(String button) {
        if (PREVIOUS_ID.equals(button)) {
            this.onPrevious();
        } else {
            super.onButton(button);
        }
    }

    private void onPrevious() {
        if (this.history.size() > 1) {
            this.history.pop();
            IMObject object = null;
            while (object == null && !this.history.isEmpty()) {
                Reference previous = this.history.pop();
                object = IMObjectHelper.getObject(previous, this.context);
            }
            if (object != null) {
                this.setObject(object);
            } else {
                this.enableButtons();
            }
        }
    }

    private void enableButtons() {
        this.getButtons().setEnabled(PREVIOUS_ID, this.history.size() > 1);
    }

    private void changeObject(IMObject object) {
        if (this.listener != null) {
            this.close();
            this.listener.switchTo(object);
        } else {
            this.setObject(object);
        }
    }
}

