/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.view;

import java.lang.reflect.Constructor;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandlers;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.DefaultIMObjectCollectionViewer;
import org.openvpms.web.component.im.view.DefaultSingleIMObjectCollectionViewer;
import org.openvpms.web.component.im.view.IMObjectCollectionViewer;
import org.openvpms.web.component.property.CollectionProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMObjectCollectionViewerFactory {
    private static ArchetypeHandlers<IMObjectCollectionViewer> viewers;
    private static final Logger log;

    private IMObjectCollectionViewerFactory() {
    }

    public static IMObjectCollectionViewer create(CollectionProperty collection, IMObject object, LayoutContext context) {
        IMObjectCollectionViewer result = null;
        String[] shortNames = collection.getArchetypeRange();
        if (shortNames.length == 0) {
            throw new IllegalStateException(object.getArchetype() + " has an invalid archetypeRange specification for node=" + collection.getName());
        }
        ArchetypeHandler handler = IMObjectCollectionViewerFactory.getViewers().getHandler(shortNames);
        if (handler != null) {
            Class type = handler.getType();
            Constructor<?> ctor = IMObjectCollectionViewerFactory.getConstructor(type, collection, object, context);
            if (ctor != null) {
                try {
                    result = (IMObjectCollectionViewer)ctor.newInstance(collection, object, context);
                }
                catch (Throwable throwable) {
                    log.error(throwable.getMessage(), throwable);
                }
            } else {
                log.error("No valid constructor found for class: " + type.getName());
            }
        }
        if (result == null) {
            result = collection.getMaxCardinality() == 1 ? new DefaultSingleIMObjectCollectionViewer(collection, object, context) : new DefaultIMObjectCollectionViewer(collection, object, context);
        }
        return result;
    }

    private static synchronized ArchetypeHandlers<IMObjectCollectionViewer> getViewers() {
        if (viewers == null) {
            viewers = new ArchetypeHandlers("IMObjectCollectionViewerFactory.properties", "DefaultIMObjectCollectionViewerFactory.properties", IMObjectCollectionViewer.class, (ArchetypeService)ArchetypeServiceHelper.getArchetypeService());
        }
        return viewers;
    }

    private static Constructor<?> getConstructor(Class<?> type, CollectionProperty collection, IMObject object, LayoutContext context) {
        Constructor<?>[] ctors;
        for (Constructor<?> ctor : ctors = type.getConstructors()) {
            Class<?>[] ctorTypes = ctor.getParameterTypes();
            if (ctorTypes.length != 3) continue;
            Class<?> ctorCollection = ctorTypes[0];
            Class<?> ctorObj = ctorTypes[1];
            Class<?> ctorCtx = ctorTypes[2];
            if (!ctorCollection.isAssignableFrom(collection.getClass()) || !ctorObj.isAssignableFrom(object.getClass()) || (context == null || !ctorCtx.isAssignableFrom(context.getClass())) && (context != null || !LayoutContext.class.isAssignableFrom(ctorCtx))) continue;
            return ctor;
        }
        return null;
    }

    static {
        log = LoggerFactory.getLogger(IMObjectCollectionViewerFactory.class);
    }
}

