/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.table;

import java.io.Serializable;
import java.util.List;
import nextapp.echo2.app.event.TableModelListener;
import nextapp.echo2.app.list.ListSelectionModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.echo.table.EvenOddTableCellRenderer;
import org.openvpms.web.echo.table.KeyTable;

public class IMTable<T>
extends KeyTable {
    private final TableModelListener modelListener = (TableModelListener & Serializable)event -> {
        if (event.getType() == 4) {
            this.initialise(model);
        } else if (event.getFirstRow() != event.getLastRow()) {
            this.setSelected(null);
        }
    };

    public IMTable(IMTableModel<T> model) {
        this.setStyleName("default");
        this.setAutoCreateColumnsFromModel(false);
        this.setModel(model);
        model.addTableModelListener(this.modelListener);
        this.initialise(model);
    }

    public void setObjects(List<T> objects) {
        this.getModel().setObjects(objects);
    }

    public List<T> getObjects() {
        return this.getModel().getObjects();
    }

    public T getSelected() {
        List<T> objects;
        T result = null;
        int index = this.getSelectionModel().getMinSelectedIndex();
        if (index != -1 && index < (objects = this.getModel().getObjects()).size()) {
            result = objects.get(index);
        }
        return result;
    }

    public boolean setSelected(T object) {
        boolean result = false;
        int index = this.getObjects().indexOf(object);
        ListSelectionModel selection = this.getSelectionModel();
        if (index != -1) {
            selection.setSelectedIndex(index, true);
            result = true;
        } else {
            selection.clearSelection();
        }
        return result;
    }

    public boolean deselect(T object) {
        boolean result = false;
        int index = this.getObjects().indexOf(object);
        ListSelectionModel selection = this.getSelectionModel();
        if (index != -1) {
            selection.setSelectedIndex(index, false);
            result = true;
        }
        return result;
    }

    public IMTableModel<T> getModel() {
        return (IMTableModel)super.getModel();
    }

    public void setModel(IMTableModel<T> model) {
        super.setModel(model);
    }

    private void initialise(IMTableModel<T> model) {
        this.setSelectionEnabled(model.getEnableSelection());
        this.setRolloverEnabled(model.getEnableSelection());
        IMTableModel<T> current = this.getModel();
        this.setModel(model);
        this.setColumnModel(model.getColumnModel());
        if (this.getDefaultRenderer(Object.class) == null) {
            this.setDefaultRenderer(Object.class, EvenOddTableCellRenderer.INSTANCE);
        }
        if (current != model) {
            model.addTableModelListener(this.modelListener);
        }
    }
}

