/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.table;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.layout.TableLayoutData;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.ListMarkModel;
import org.openvpms.web.echo.button.CheckBox;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.table.AbstractTableModel;
import org.openvpms.web.echo.table.TableColumnFactory;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.echo.text.TextHelper;
import org.openvpms.web.system.ServiceHelper;

public abstract class AbstractIMTableModel<T>
extends AbstractTableModel
implements IMTableModel<T> {
    public static final int MARK_INDEX = 0;
    protected static final String ID = "table.imobject.id";
    protected static final String ARCHETYPE = "table.imobject.archetype";
    protected static final String NAME = "table.imobject.name";
    protected static final String DESCRIPTION = "table.imobject.description";
    protected static final String ACTIVE = "table.imobject.active";
    private List<T> objects = new ArrayList<T>();
    private int defaultSortColumn = -1;
    private boolean defaultSortAscending = true;
    private boolean enableSelection = true;
    private ListMarkModel rowMarkModel;
    private ListMarkModel.Listener rowMarkListener;
    private nextapp.echo2.app.CheckBox markAllNone;
    private nextapp.echo2.app.CheckBox[] rowMarks;

    public AbstractIMTableModel() {
    }

    public AbstractIMTableModel(TableColumnModel model) {
        super(model);
    }

    public int getRowCount() {
        return this.objects.size();
    }

    @Override
    public void setObjects(List<T> objects) {
        this.objects = objects;
        if (this.rowMarkModel != null) {
            this.rowMarkModel.clear();
        }
        if (this.markAllNone != null) {
            this.markAllNone.setSelected(false);
        }
        this.rowMarks = null;
        this.fireTableDataChanged();
    }

    @Override
    public List<T> getObjects() {
        return this.objects;
    }

    public T getObject(int row) {
        return this.objects.get(row);
    }

    public Object getValueAt(int column, int row) {
        TableColumn col = this.getColumn(column);
        if (col == null) {
            throw new IllegalArgumentException("Illegal column=" + column);
        }
        return this.getValueAt(col, row);
    }

    public Object getValueAt(TableColumn column, int row) {
        T object = this.getObject(row);
        Object result = this.getValue(object, column, row);
        if (result instanceof String) {
            String str = (String)result;
            if (TextHelper.hasControlChars((String)str)) {
                str = TextHelper.replaceControlChars((String)str, (String)" ");
            }
            result = str;
        }
        return result;
    }

    @Override
    public int getDefaultSortColumn() {
        return this.defaultSortColumn;
    }

    public void setDefaultSortColumn(int column) {
        this.defaultSortColumn = column;
    }

    @Override
    public boolean getDefaultSortAscending() {
        return this.defaultSortAscending;
    }

    public void setDefaultSortAscending(boolean ascending) {
        this.defaultSortAscending = ascending;
    }

    @Override
    public boolean getEnableSelection() {
        return this.enableSelection;
    }

    @Override
    public void setEnableSelection(boolean enable) {
        this.enableSelection = enable;
    }

    @Override
    public void setRowMarkModel(ListMarkModel model) {
        if (this.rowMarkListener == null) {
            this.rowMarkListener = new ListMarkModel.Listener(){

                @Override
                public void changed(int index, boolean marked) {
                    AbstractIMTableModel.this.markRow(index, marked);
                }

                @Override
                public void cleared() {
                    AbstractIMTableModel.this.rowsUnmarked();
                }
            };
        } else if (this.rowMarkModel != null) {
            this.rowMarkModel.removeListener(this.rowMarkListener);
        }
        this.rowMarkModel = model;
        if (this.rowMarkModel != null) {
            this.rowMarkModel.addListener(this.rowMarkListener);
        }
    }

    @Override
    public ListMarkModel getRowMarkModel() {
        return this.rowMarkModel;
    }

    @Override
    public List<T> getMarkedRows() {
        ArrayList<T> result = new ArrayList<T>();
        if (this.rowMarkModel != null && !this.rowMarkModel.isEmpty()) {
            int rows = this.getRowCount();
            for (int i = 0; i < rows; ++i) {
                if (!this.rowMarkModel.isMarked(i)) continue;
                result.add(this.objects.get(i));
            }
        }
        return result;
    }

    @Override
    public void refresh() {
        this.fireTableDataChanged();
    }

    public void preRender() {
    }

    public void postRender() {
    }

    protected abstract Object getValue(T var1, TableColumn var2, int var3);

    protected void addMarkColumn(TableColumnModel model) {
        TableColumn column = new TableColumn(0);
        this.markAllNone = CheckBoxFactory.create();
        this.markAllNone.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                boolean mark = AbstractIMTableModel.this.markAllNone.isSelected();
                AbstractIMTableModel.this.markRows(mark);
            }
        });
        column.setHeaderValue((Object)this.markAllNone);
        model.addColumn(column);
        model.moveColumn(model.getColumnCount() - 1, 0);
    }

    protected nextapp.echo2.app.CheckBox getRowMark(int row) {
        nextapp.echo2.app.CheckBox result = null;
        ListMarkModel model = this.getRowMarkModel();
        if (model != null) {
            if (this.rowMarks == null) {
                this.rowMarks = new nextapp.echo2.app.CheckBox[this.getRowCount()];
            }
            if ((result = this.rowMarks[row]) == null) {
                CheckBox checkBox;
                if (model.canMark(row)) {
                    checkBox = CheckBoxFactory.create((boolean)model.isMarked(row));
                    checkBox.addPropertyChangeListener(arg_0 -> this.lambda$getRowMark$0(row, (nextapp.echo2.app.CheckBox)checkBox, arg_0));
                    checkBox.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                        public void onAction(ActionEvent event) {
                        }
                    });
                    this.rowMarks[row] = checkBox;
                } else {
                    checkBox = CheckBoxFactory.create((boolean)false);
                    checkBox.setEnabled(false);
                }
                TableLayoutData layout = new TableLayoutData();
                layout.setAlignment(Alignment.ALIGN_CENTER);
                checkBox.setLayoutData((LayoutData)layout);
                result = checkBox;
            }
        }
        return result;
    }

    protected boolean allMarked() {
        boolean result = false;
        int rows = this.getRowCount();
        if (this.rowMarkModel != null && rows != 0) {
            boolean marked = true;
            for (int i = 0; i < rows; ++i) {
                if (this.rowMarkModel.isMarked(i)) continue;
                marked = false;
                break;
            }
            result = marked;
        }
        return result;
    }

    protected void markRow(int row, boolean marked) {
        nextapp.echo2.app.CheckBox checkBox = this.getRowMark(row);
        if (checkBox.isSelected() != marked) {
            checkBox.setSelected(marked);
        }
        if (this.markAllNone != null) {
            this.markAllNone.setSelected(this.allMarked());
        }
    }

    protected void rowsUnmarked() {
        this.rowMarks = null;
        if (this.markAllNone != null) {
            this.markAllNone.setSelected(false);
        }
        this.fireTableDataChanged();
    }

    protected void markRow(int row, nextapp.echo2.app.CheckBox checkBox) {
        ListMarkModel model = this.getRowMarkModel();
        if (model != null) {
            model.setMarked(row, checkBox.isSelected());
        }
    }

    protected void markRows(boolean mark) {
        if (this.rowMarkModel != null) {
            int marked = 0;
            int rows = this.getRowCount();
            for (int i = 0; i < rows; ++i) {
                if (mark && this.rowMarkModel.canMark(i)) {
                    this.rowMarkModel.setMarked(i, true);
                    ++marked;
                    continue;
                }
                if (mark) continue;
                this.rowMarkModel.setMarked(i, false);
            }
            if (this.markAllNone != null && marked != rows) {
                this.markAllNone.setSelected(false);
            }
        }
    }

    protected int getColumnOffset(TableColumnModel model, int column) {
        return TableHelper.getColumnOffset((TableColumnModel)model, (int)column);
    }

    protected void addColumnAfter(TableColumn column, int after, TableColumnModel model) {
        model.addColumn(column);
        int columnOffset = this.getColumnOffset(model, after);
        if (columnOffset != -1) {
            model.moveColumn(model.getColumnCount() - 1, columnOffset + 1);
        }
    }

    protected int getNextModelIndex(TableColumnModel columns) {
        return this.getNextModelIndex(columns, 0);
    }

    protected int getNextModelIndex(TableColumnModel columns, int from) {
        return TableHelper.getNextModelIndex((TableColumnModel)columns, (int)from);
    }

    protected nextapp.echo2.app.CheckBox getActive(IMObject object) {
        return this.getCheckBox(object.isActive());
    }

    protected nextapp.echo2.app.CheckBox getCheckBox(boolean selected) {
        nextapp.echo2.app.CheckBox result = new nextapp.echo2.app.CheckBox();
        result.setEnabled(false);
        result.setSelected(selected);
        return result;
    }

    protected IMObjectBean getBean(IMObject object) {
        return this.getService().getBean(object);
    }

    protected ArchetypeService getService() {
        return ServiceHelper.getArchetypeService();
    }

    protected String getDisplayName(IMObject object) {
        return DescriptorHelper.getDisplayName((IMObject)object, (ArchetypeService)this.getService());
    }

    protected String getDisplayName(IMObject object, String node) {
        return DescriptorHelper.getDisplayName((IMObject)object, (String)node, (ArchetypeService)this.getService());
    }

    protected String getDisplayName(String archetype) {
        return DescriptorHelper.getDisplayName((String)archetype, (ArchetypeService)this.getService());
    }

    protected String getDisplayName(String archetype, String node) {
        return DescriptorHelper.getDisplayName((String)archetype, (String)node, (ArchetypeService)this.getService());
    }

    protected static TableColumn createTableColumn(int index, String headerKey) {
        return TableColumnFactory.createKey((int)index, (String)headerKey);
    }

    protected static TableColumn createTableColumn(int index, String headerKey, TableCellRenderer renderer) {
        return TableColumnFactory.createKey((int)index, (String)headerKey, null, (TableCellRenderer)renderer);
    }

    private /* synthetic */ void lambda$getRowMark$0(int row, nextapp.echo2.app.CheckBox checkBox, PropertyChangeEvent evt) {
        this.markRow(row, checkBox);
    }
}

