/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.select;

import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserFactory;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryFactory;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.select.AbstractQuerySelector;
import org.openvpms.web.component.im.select.Selector;
import org.openvpms.web.component.property.Property;

public class IMObjectSelector<T extends IMObject>
extends AbstractQuerySelector<T> {
    private final String[] archetypes;

    public IMObjectSelector(Property property, LayoutContext context) {
        this(property, false, context);
    }

    public IMObjectSelector(Property property, boolean allowCreate, LayoutContext context) {
        this(property.getDisplayName(), allowCreate, context, property.getArchetypeRange());
    }

    public IMObjectSelector(String type, LayoutContext context, String ... archetypes) {
        this(type, false, context, archetypes);
    }

    public IMObjectSelector(String type, boolean allowCreate, LayoutContext context, String ... archetypes) {
        this(type, allowCreate, Selector.ButtonStyle.RIGHT, context, archetypes);
    }

    public IMObjectSelector(String type, boolean allowCreate, Selector.ButtonStyle style, LayoutContext context, String ... archetypes) {
        super(type, allowCreate, style, true, context);
        this.archetypes = archetypes;
    }

    public String[] getShortNames() {
        return this.archetypes;
    }

    @Override
    protected String getName(T object) {
        return object.getName();
    }

    @Override
    protected String getDescription(T object) {
        return object.getDescription();
    }

    @Override
    protected boolean getActive(T object) {
        return object.isActive();
    }

    @Override
    protected Browser<T> createBrowser(String value, boolean runQuery) {
        Query<T> query = this.createQuery(value);
        if (runQuery) {
            query.setAuto(true);
        }
        return this.createBrowser(query);
    }

    @Override
    protected ResultSet<T> getMatches(String value) {
        return this.createQuery(value).query(null);
    }

    protected Query<T> createQuery(String value) {
        Query query = QueryFactory.create(this.archetypes, this.getContext().getContext());
        query.setValue(value);
        return query;
    }

    protected Browser<T> createBrowser(Query<T> query) {
        return BrowserFactory.create(query, this.getContext());
    }
}

