/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.report;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.LookupHelper;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.report.ReportException;
import org.openvpms.report.i18n.ReportMessages;
import org.openvpms.web.component.im.doc.FileNameFormatter;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.Reporter;

public abstract class TemplatedReporter<T>
extends Reporter<T> {
    private final FileNameFormatter formatter;
    private final ArchetypeService service;
    private final LookupService lookups;
    private DocumentTemplate template;
    private DocumentTemplateLocator locator;
    private Map<String, String> templateNames;

    public TemplatedReporter(T object, DocumentTemplate template, FileNameFormatter formatter, ArchetypeService service, LookupService lookups) {
        super(object);
        this.template = template;
        this.formatter = formatter;
        this.service = service;
        this.lookups = lookups;
    }

    public TemplatedReporter(T object, DocumentTemplateLocator locator, FileNameFormatter formatter, ArchetypeService service, LookupService lookups) {
        super(object);
        this.locator = locator;
        this.formatter = formatter;
        this.service = service;
        this.lookups = lookups;
    }

    public TemplatedReporter(Iterable<T> objects, DocumentTemplate template, FileNameFormatter formatter, ArchetypeService service, LookupService lookups) {
        super(objects);
        this.template = template;
        this.formatter = formatter;
        this.service = service;
        this.lookups = lookups;
    }

    public TemplatedReporter(Iterable<T> objects, DocumentTemplateLocator locator, FileNameFormatter formatter, ArchetypeService service, LookupService lookups) {
        super(objects);
        this.locator = locator;
        this.formatter = formatter;
        this.service = service;
        this.lookups = lookups;
    }

    public String getType() {
        return this.locator.getType();
    }

    public String getDisplayName() {
        String result = null;
        DocumentTemplate template = this.getTemplate();
        if (template != null) {
            result = template.getName();
        }
        if (StringUtils.isEmpty(result)) {
            String shortName;
            if (this.templateNames == null) {
                this.templateNames = LookupHelper.getNames((LookupService)this.lookups, (String)"lookup.documentTemplateType");
            }
            if ((result = this.templateNames.get(shortName = this.getType())) == null) {
                result = DescriptorHelper.getDisplayName((String)shortName, (ArchetypeService)this.service);
            }
        }
        return result;
    }

    @Override
    public DocumentTemplate getTemplate() {
        if (this.template == null && this.locator != null) {
            this.template = this.locator.getTemplate();
        }
        return this.template;
    }

    protected DocumentTemplate resolveTemplate() {
        DocumentTemplate template = this.getTemplate();
        if (template == null) {
            String type = this.getType();
            Lookup lookup = this.lookups.getLookup("lookup.documentTemplateType", type);
            String name = lookup != null ? lookup.getName() : type;
            throw new ReportException(ReportMessages.noTemplateForType((String)name));
        }
        return template;
    }

    protected void setTemplate(DocumentTemplate template) {
        this.template = template;
    }

    @Override
    protected void setName(Document document) {
        DocumentTemplate template = this.getTemplate();
        if (template != null) {
            Iterator iterator;
            Object value = this.getObject();
            if (value == null && (iterator = this.getObjects().iterator()).hasNext()) {
                value = iterator.next();
            }
            if (value instanceof IMObject) {
                IMObject object = (IMObject)value;
                String fileName = this.formatter.format(template.getName(), object, template);
                String extension = FilenameUtils.getExtension((String)document.getName());
                document.setName(fileName + "." + extension);
            }
            super.setName(document);
        }
    }

    protected ArchetypeService getService() {
        return this.service;
    }
}

