/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.report;

import java.lang.reflect.Modifier;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandlers;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.report.ReportFactory;
import org.openvpms.web.component.im.doc.FileNameFormatter;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.IMObjectReporter;
import org.openvpms.web.component.im.report.ObjectSetReporter;
import org.openvpms.web.component.im.report.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class ReporterFactory {
    private final ReportFactory factory;
    private final FileNameFormatter formatter;
    private final ArchetypeService service;
    private final LookupService lookups;
    private final ArchetypeHandlers<? extends Reporter<?>> reporters;
    private static final Logger log = LoggerFactory.getLogger(ReporterFactory.class);

    public ReporterFactory(ReportFactory factory, FileNameFormatter formatter, IArchetypeService service, LookupService lookups) {
        this.factory = factory;
        this.formatter = formatter;
        this.service = service;
        this.lookups = lookups;
        Class<Reporter> type = Reporter.class;
        this.reporters = new ArchetypeHandlers("ReporterFactory.properties", null, type, "reporter", (ArchetypeService)service);
    }

    public <T extends IMObject, R extends Reporter<T>> R create(T object, DocumentTemplate template, Class<R> type) {
        Object result = this.newInstance(object.getArchetype(), object, template, type);
        if (result == null) {
            if (type.isAssignableFrom(IMObjectReporter.class)) {
                result = this.createIMObjectReporter(object, template);
            } else {
                throw new IllegalArgumentException("No Reporters extend " + type.getName() + " and support archetype=" + object.getArchetype());
            }
        }
        return result;
    }

    public <T extends IMObject, R extends Reporter<T>> R create(Iterable<T> objects, DocumentTemplate template, Class<R> type) {
        Object result = this.newInstance(template.getType(), objects, template, type);
        if (result == null) {
            if (type.isAssignableFrom(IMObjectReporter.class)) {
                result = this.createIMObjectReporter(objects, template);
            } else {
                throw new IllegalArgumentException("No Reporters extend " + type.getName() + " and support archetype=" + template.getType());
            }
        }
        return result;
    }

    public <T extends IMObject, R extends Reporter<T>> R create(T object, DocumentTemplateLocator locator, Class<R> type) {
        Object result = this.newInstance(object.getArchetype(), object, locator, type);
        if (result == null) {
            if (type.isAssignableFrom(IMObjectReporter.class)) {
                result = this.createIMObjectReporter(object, locator);
            } else {
                throw new IllegalArgumentException("No Reporters extend " + type.getName() + " and support archetype=" + object.getArchetype());
            }
        }
        return result;
    }

    public <T extends IMObject, R extends Reporter<T>> R create(Iterable<T> objects, DocumentTemplateLocator locator, Class<R> type) {
        Object result = this.newInstance(locator.getType(), objects, locator, type);
        if (result == null) {
            if (type.isAssignableFrom(IMObjectReporter.class)) {
                result = this.createIMObjectReporter(objects, locator);
            } else {
                throw new IllegalArgumentException("No Reporters extend " + type.getName() + " and support type=" + locator.getType());
            }
        }
        return result;
    }

    public <T extends IMObject> IMObjectReporter<T> createIMObjectReporter(T object, DocumentTemplate template) {
        return new IMObjectReporter<T>(object, template, this.factory, this.formatter, this.service, this.lookups);
    }

    public <T extends IMObject> IMObjectReporter<T> createIMObjectReporter(T object, DocumentTemplateLocator locator) {
        return new IMObjectReporter<T>(object, locator, this.factory, this.formatter, this.service, this.lookups);
    }

    public <T extends IMObject> IMObjectReporter<T> createIMObjectReporter(Iterable<T> objects, DocumentTemplate template) {
        return new IMObjectReporter<T>(objects, template, this.factory, this.formatter, this.service, this.lookups);
    }

    public <T extends IMObject> IMObjectReporter<T> createIMObjectReporter(Iterable<T> objects, DocumentTemplateLocator locator) {
        return new IMObjectReporter<T>(objects, locator, this.factory, this.formatter, this.service, this.lookups);
    }

    public ObjectSetReporter createObjectSetReporter(Iterable<ObjectSet> objects, DocumentTemplate template) {
        return new ObjectSetReporter(objects, template, this.factory, this.formatter, this.service, this.lookups);
    }

    public ObjectSetReporter createObjectSetReporter(Iterable<ObjectSet> objects, DocumentTemplateLocator locator) {
        return new ObjectSetReporter(objects, locator, this.factory, this.formatter, this.service, this.lookups);
    }

    private <R extends Reporter<?>> R newInstance(String archetype, Object object, Object template, Class<R> type) {
        boolean concrete = !type.isInterface() && !Modifier.isAbstract(type.getModifiers());
        ArchetypeHandler handler = concrete ? this.reporters.getHandler(type) : this.reporters.getHandler(archetype);
        Object result = null;
        if (handler != null) {
            if (!type.isAssignableFrom(handler.getType())) {
                log.error("Reporter of type " + handler.getClass().getName() + " for archetype=" + archetype + " is not an instance of " + type.getName());
            } else {
                DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
                beanFactory.registerSingleton("object", object);
                beanFactory.registerSingleton("template", template);
                beanFactory.registerSingleton("factory", (Object)this.factory);
                beanFactory.registerSingleton("formatter", (Object)this.formatter);
                beanFactory.registerSingleton("service", (Object)this.service);
                beanFactory.registerSingleton("lookups", (Object)this.lookups);
                try {
                    result = beanFactory.createBean(handler.getType(), 3, false);
                }
                catch (Throwable exception) {
                    log.error(exception.getMessage(), exception);
                }
            }
        }
        return (R)((Reporter)result);
    }
}

