/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.report;

import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.model.document.Document;
import org.openvpms.report.IMReport;
import org.openvpms.report.ParameterType;
import org.openvpms.report.PrintProperties;
import org.openvpms.report.Report;
import org.openvpms.web.component.im.report.ReportRunner;

public abstract class Reporter<T> {
    public static final String DEFAULT_MIME_TYPE = "application/pdf";
    private final Iterable<T> objects;
    private final T object;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private Map<String, Object> fields;

    public Reporter(T object) {
        this.objects = Collections.singletonList(object);
        this.object = object;
    }

    public Reporter(Iterable<T> objects) {
        this.objects = objects;
        this.object = null;
    }

    public T getObject() {
        return this.object;
    }

    public Iterable<T> getObjects() {
        return this.objects;
    }

    public Document getDocument() {
        return this.getDocument(null, false);
    }

    public Document getDocument(String type, boolean email) {
        IMReport<T> report = this.getReport();
        if (type == null) {
            type = report.getDefaultMimeType();
        }
        String mimeType = type;
        HashMap<String, Object> map = new HashMap<String, Object>(this.getParameters(email));
        Document document = this.generate(report, () -> report.generate(this.getObjects(), map, this.fields, mimeType));
        this.setName(document);
        return document;
    }

    public boolean canPrint() {
        return this.getReport().canPrint();
    }

    public void print(PrintProperties properties) {
        IMReport<T> report = this.getReport();
        this.generate(report, () -> report.print(this.getObjects(), this.getParameters(false), this.fields, properties));
    }

    public void generate(String type, boolean email, OutputStream stream) {
        IMReport<T> report = this.getReport();
        if (type == null) {
            type = report.getDefaultMimeType();
        }
        String mimeType = type;
        HashMap<String, Object> map = new HashMap<String, Object>(this.getParameters(email));
        this.generate(report, () -> report.generate(this.getObjects(), map, this.fields, mimeType, stream));
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Set<ParameterType> getParameterTypes() {
        LinkedHashSet<ParameterType> result = new LinkedHashSet<ParameterType>();
        for (ParameterType type : this.getReport().getParameterTypes()) {
            if ("IsEmail".equals(type.getName())) continue;
            result.add(type);
        }
        return result;
    }

    public void setFields(Map<String, Object> fields) {
        this.fields = fields;
    }

    public DocumentTemplate getTemplate() {
        return null;
    }

    protected abstract IMReport<T> getReport();

    protected Map<String, Object> getParameters(boolean email) {
        Map<String, Object> result;
        if (this.getReport().hasParameter("IsEmail")) {
            result = new HashMap<String, Object>();
            if (this.parameters != null) {
                result.putAll(this.parameters);
            }
            result.put("IsEmail", email);
        } else {
            result = this.parameters;
        }
        return result;
    }

    protected void setName(Document document) {
    }

    private Document generate(IMReport<T> report, Supplier<Document> generator) {
        return new ReportRunner((Report)report, this.object).run(generator);
    }

    private void generate(IMReport<T> report, Runnable generator) {
        new ReportRunner((Report)report, this.object).run(generator);
    }
}

