/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.report;

import java.lang.reflect.Constructor;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.handler.ArchetypeHandlers;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentTemplateLocatorFactory {
    private final ArchetypeHandlers<DocumentTemplateLocator> handlers;
    private static final Logger log = LoggerFactory.getLogger(DocumentTemplateLocatorFactory.class);

    public DocumentTemplateLocatorFactory(ArchetypeService service) {
        this.handlers = new ArchetypeHandlers("DefaultDocumentTemplateLocatorFactory", DocumentTemplateLocator.class, service);
    }

    public DocumentTemplate getTemplate(IMObject object, Context context) {
        DocumentTemplateLocator locator = this.getDocumentTemplateLocator(object, context);
        return locator.getTemplate();
    }

    public DocumentTemplateLocator getDocumentTemplateLocator(IMObject object, Context context) {
        ArchetypeHandler handler = this.handlers.getHandler(object.getArchetype());
        DocumentTemplateLocator locator = null;
        if (handler != null) {
            try {
                locator = this.create((ArchetypeHandler<DocumentTemplateLocator>)handler, object, context);
                if (locator == null) {
                    locator = this.create((ArchetypeHandler<DocumentTemplateLocator>)handler, object);
                }
                if (locator == null) {
                    locator = this.create((ArchetypeHandler<DocumentTemplateLocator>)handler, new Object[0]);
                }
            }
            catch (Exception exception) {
                log.warn("Failed to create {}: {}", new Object[]{handler.getType(), exception.getMessage(), exception});
            }
        }
        if (locator == null) {
            locator = new ContextDocumentTemplateLocator(object, context);
        }
        return locator;
    }

    private DocumentTemplateLocator create(ArchetypeHandler<DocumentTemplateLocator> handler, Object ... parameters) throws Exception {
        Class[] types = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            types[i] = parameters[i].getClass();
        }
        Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)handler.getType(), (Class[])types);
        return constructor != null ? (DocumentTemplateLocator)constructor.newInstance(parameters) : null;
    }
}

