/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.report;

import org.openvpms.archetype.rules.doc.BaseDocumentTemplate;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.report.IMReport;
import org.openvpms.report.ReportFactory;
import org.openvpms.web.component.im.doc.FileNameFormatter;
import org.openvpms.web.component.im.report.DocumentActTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.TemplatedReporter;

public class DocumentActReporter
extends TemplatedReporter<IMObject> {
    private final ReportFactory reportFactory;
    private IMReport<IMObject> report;
    private static final String DOCUMENT_TEMPLATE = "documentTemplate";

    public DocumentActReporter(DocumentAct act, FileNameFormatter formatter, ArchetypeService service, LookupService lookups, ReportFactory reportFactory) {
        this(act, DocumentActReporter.getTemplate(act, true, service), formatter, service, lookups, reportFactory);
    }

    public DocumentActReporter(DocumentAct act, DocumentTemplate template, FileNameFormatter formatter, ArchetypeService service, LookupService lookups, ReportFactory reportFactory) {
        super(act, template, formatter, service, lookups);
        this.reportFactory = reportFactory;
    }

    public DocumentActReporter(DocumentAct act, DocumentTemplateLocator locator, FileNameFormatter formatter, ArchetypeService service, LookupService lookups, ReportFactory reportFactory) {
        super(act, locator, formatter, service, lookups);
        this.reportFactory = reportFactory;
        this.setTemplate(DocumentActReporter.getTemplate(act, false, service));
    }

    @Override
    public IMReport<IMObject> getReport() {
        if (this.report == null) {
            this.report = this.createReport();
        }
        return this.report;
    }

    public static DocumentTemplate getTemplate(DocumentAct act, ArchetypeService service) {
        Entity template;
        DocumentTemplate result = null;
        IMObjectBean bean = service.getBean((IMObject)act);
        if (bean.hasNode(DOCUMENT_TEMPLATE) && (template = (Entity)bean.getTarget(DOCUMENT_TEMPLATE, Entity.class)) != null) {
            result = new DocumentTemplate(template, service);
        }
        return result;
    }

    protected IMReport<IMObject> createReport() {
        DocumentTemplate template = this.resolveTemplate();
        return this.reportFactory.isIMObjectReport((BaseDocumentTemplate)template) ? this.reportFactory.createIMObjectReport((BaseDocumentTemplate)template) : this.reportFactory.createStaticContentReport(template);
    }

    protected ReportFactory getReportFactory() {
        return this.reportFactory;
    }

    private static DocumentTemplate getTemplate(DocumentAct act, boolean required, ArchetypeService service) {
        DocumentActTemplateLocator locator = new DocumentActTemplateLocator(act, service);
        DocumentTemplate template = locator.getTemplate();
        if (template == null && required) {
            throw new DocumentException(DocumentException.ErrorCode.DocumentHasNoTemplate, new Object[]{DescriptorHelper.getDisplayName((IMObject)act, (ArchetypeService)service)});
        }
        return template;
    }
}

