/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.util.List;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.relationship.RelationshipCollectionViewer;
import org.openvpms.web.component.im.relationship.RelationshipState;
import org.openvpms.web.component.im.relationship.SequencedRelationshipCollectionHelper;
import org.openvpms.web.component.property.CollectionProperty;

public class SequencedRelationshipCollectionViewer
extends RelationshipCollectionViewer {
    private final boolean sequenced;

    public SequencedRelationshipCollectionViewer(CollectionProperty property, Entity parent, LayoutContext context) {
        super(property, (IMObject)parent, context);
        this.sequenced = SequencedRelationshipCollectionHelper.hasSequenceNode(property.getArchetypeRange());
    }

    @Override
    protected ResultSet<RelationshipState> createResultSet() {
        if (this.sequenced) {
            List<RelationshipState> states = this.getRelationshipStates();
            SequencedRelationshipCollectionHelper.sortStates(states);
            return new ListResultSet<RelationshipState>(states, 15);
        }
        return super.createResultSet();
    }
}

