/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.service.archetype.ArchetypeService;

public class RelationshipHelper {
    public static Reference getRelated(IMObject primary, Relationship relationship) {
        return RelationshipHelper.getRelated(primary.getObjectReference(), relationship);
    }

    public static Reference getRelated(Reference primary, Relationship relationship) {
        return primary.equals((Object)relationship.getSource()) ? relationship.getTarget() : relationship.getSource();
    }

    public static String[] getTargetShortNames(ArchetypeService service, String ... relationshipTypes) {
        return DescriptorHelper.getNodeShortNames((String[])relationshipTypes, (String)"target", (ArchetypeService)service);
    }

    public static <R extends Relationship, T extends IMObject> List<T> getTargets(List<R> relationships, ArchetypeService service) {
        ArrayList<IMObject> targets = new ArrayList<IMObject>();
        for (Relationship relationship : relationships) {
            IMObject target;
            if (relationship.getTarget() == null || (target = service.get(relationship.getTarget())) == null) continue;
            targets.add(target);
        }
        return targets;
    }
}

