/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMTableCollectionEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.relationship.DelegatingRelationshipStateTableModel;
import org.openvpms.web.component.im.relationship.RelationshipCollectionPropertyEditor;
import org.openvpms.web.component.im.relationship.RelationshipDescriptorTableModel;
import org.openvpms.web.component.im.relationship.RelationshipState;
import org.openvpms.web.component.im.relationship.RelationshipStateResultSet;
import org.openvpms.web.component.im.relationship.RelationshipStateTableModel;
import org.openvpms.web.component.im.table.IMObjectTableModel;
import org.openvpms.web.component.im.table.IMObjectTableModelFactory;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.view.TableComponentFactory;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.table.TableNavigator;
import org.openvpms.web.resource.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipCollectionEditor
extends IMTableCollectionEditor<RelationshipState> {
    private static final Logger log = LoggerFactory.getLogger(RelationshipCollectionEditor.class);
    private CheckBox hideInactive;
    private static final String DEFAULT = "default";

    protected RelationshipCollectionEditor(RelationshipCollectionPropertyEditor editor, IMObject object, LayoutContext context) {
        super(editor, object, context);
    }

    @Override
    protected boolean addEdited(IMObjectEditor editor) {
        return super.addEdited(editor);
    }

    @Override
    protected IMTableModel<RelationshipState> createTableModel(LayoutContext context) {
        RelationshipCollectionPropertyEditor editor = this.getCollectionPropertyEditor();
        String[] archetypes = editor.getArchetypeRange();
        if (IMObjectTableModelFactory.hasModel(archetypes, RelationshipDescriptorTableModel.class)) {
            if (!(context.getComponentFactory() instanceof TableComponentFactory)) {
                context = new DefaultLayoutContext(context);
                context.setComponentFactory(new TableComponentFactory(context));
            }
            IMObjectTableModel<Relationship> model = IMObjectTableModelFactory.create(archetypes, context);
            return new DelegatingRelationshipStateTableModel(model, context);
        }
        return new RelationshipStateTableModel(context, editor.parentIsSource());
    }

    @Override
    protected void setSelected(IMObject object) {
        RelationshipState state = null;
        if (object instanceof Relationship) {
            RelationshipCollectionPropertyEditor editor = this.getCollectionPropertyEditor();
            state = editor.getRelationshipState((Relationship)object);
        } else if (object != null) {
            log.warn("{}: attempt to select related object using {} for {}", new Object[]{this.getClass().getName(), object.getObjectReference(), this.getObject().getObjectReference()});
        }
        PagedIMTable<RelationshipState> table = this.getTable();
        table.setSelected(state);
        this.enableNavigation(table.getSelected() != null, true);
    }

    @Override
    protected IMObject getSelected() {
        RelationshipState selected = (RelationshipState)this.getTable().getSelected();
        return selected != null ? selected.getRelationship() : null;
    }

    @Override
    protected IMObject selectPrevious() {
        Relationship result = null;
        PagedIMTable table = this.getTable();
        TableNavigator navigator = table.getNavigator();
        if (navigator.selectPreviousRow()) {
            result = ((RelationshipState)table.getSelected()).getRelationship();
            this.setSelected((IMObject)result);
        }
        return result;
    }

    @Override
    protected IMObject selectNext() {
        Relationship result = null;
        PagedIMTable table = this.getTable();
        TableNavigator navigator = table.getNavigator();
        if (navigator.selectNextRow()) {
            result = ((RelationshipState)table.getSelected()).getRelationship();
            this.setSelected((IMObject)result);
        }
        return result;
    }

    @Override
    protected ResultSet<RelationshipState> createResultSet() {
        RelationshipCollectionPropertyEditor editor = this.getCollectionPropertyEditor();
        ArrayList<RelationshipState> relationships = new ArrayList<RelationshipState>(editor.getRelationships());
        return new RelationshipStateResultSet((List<RelationshipState>)relationships, 15);
    }

    @Override
    protected ButtonRow createControls(FocusGroup focus) {
        ButtonRow row = super.createControls(focus);
        String name = this.getProperty().getDisplayName();
        String label = Messages.format((String)"relationship.hide.inactive", (Object[])new Object[]{name});
        this.hideInactive = CheckBoxFactory.create(null, (boolean)true);
        this.hideInactive.setText(label);
        this.hideInactive.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                RelationshipCollectionEditor.this.onHideInactiveChanged();
            }
        });
        row.add((Component)this.hideInactive);
        focus.add((Component)this.hideInactive);
        return row;
    }

    @Override
    protected RelationshipCollectionPropertyEditor getCollectionPropertyEditor() {
        return (RelationshipCollectionPropertyEditor)super.getCollectionPropertyEditor();
    }

    @Override
    protected void onCurrentEditorModified() {
        IMObjectEditor currentEditor = this.getCurrentEditor();
        if (currentEditor != null) {
            this.updateDefaults(currentEditor);
        }
        super.onCurrentEditorModified();
    }

    protected void updateDefaults(IMObjectEditor currentEditor) {
        IMObject current = currentEditor.getObject();
        Property property = currentEditor.getProperty(DEFAULT);
        if (property != null && property.getBoolean()) {
            for (IMObject object : this.getCurrentObjects()) {
                IMObjectEditor editor;
                if (current.equals(object) || (editor = this.getEditor(object)) == null) continue;
                editor.getProperty(DEFAULT).setValue(false);
            }
        }
    }

    private void onHideInactiveChanged() {
        RelationshipCollectionPropertyEditor editor = this.getCollectionPropertyEditor();
        boolean selected = this.hideInactive.isSelected();
        editor.setExcludeInactive(selected);
        IMTableModel model = this.getTable().getModel().getModel();
        if (model instanceof RelationshipStateTableModel) {
            ((RelationshipStateTableModel)model).setShowActive(!selected);
        }
        this.refresh();
    }
}

